/* REXX Program PGPckSig.CMD 1.2 */
/* to check the signature on incoming mail.
   Companion to PGPdeCode.CMD, PGPenCod.CMD (with SPLITMAIL.CMD and JOINMAIL.CMD).
     Alternate to PGPdeSig.CMD.

   Copyright Lko Willms <Lueko.Willms@T-Online.de>

   Configure this as a filter to be run when your mailer detects the string
   '-----BEGIN PGP SIGNED MESSAGE-----' in the body of an incoming mail message
*/

arg MailFile .

/* ------------------------ Get message data  ------ */

From  = ''
Sender = ''
MsgId = ''
Timestamp=Date('O')||' '||Time()
Betreff = ''

Erg = STREAM(MailFile,'C','OPEN READ')

Zeile = linein(MailFile)
ContLine = 0
DO WHILE Length(Zeile) > 0
    /* Beachte Fortsetzungszeilen!! */
    ContLine = ContLine & (LEFT(Zeile,1) = ' ' | LEFT(Zeile,1) = '09'x)
    Zeile = STRIP(Zeile)
    If \ ContLine then
       DO
       Tag = TRANSLATE(WORD(Zeile,1))
       Zeile = Delstr(Zeile,1,Length(Tag))
       END

    If RIGHT(Zeile,1) = ',' then
       DO
       ContLine = TRUE                                 /* for the next line... */
       Zeile = DELSTR(Zeile,Length(Zeile),1)
       END

    SELECT
      When (Tag = 'FROM:') then
        From = zeile
      When (Tag = 'SENDER:') then
        Sender = Zeile
      When (Tag = 'MESSAGE-ID:') then
        MsgId = Zeile
      When (Tag = 'DATE:') then
        Timestamp = Zeile
      When (Tag = 'SUBJECT:') then
        Betreff = Zeile
      Otherwise
        NOP
    END /* Switch */

    Zeile = linein(MailFile)
END /* Do Header */

Erg = STREAM(MailFile,'C','CLOSE')

'type ' MailFile ' | pgp -f 1>NUL 2>>'MailFile

/* Do logging ---------------------------------------------- */
Erfolg = RC
Tab = '09'x
PARSE SOURCE . . MyName
LogFile = FILESPEC("Path",MyName)||'PGPREXX.LOG'
Erg = STREAM(LogFile,'C','OPEN WRITE')
If Length(From) = 0 then
   From = Sender
Erg = LINEOUT(LogFile,Timestamp||Tab||'ckSig'||Tab||MsgId||Tab||Erfolg||Tab||'From: '||From)
Erg = STREAM(LogFile,'C','CLOSE')
exit
