/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CInterruptLevelTestMgr.cp,v 1.6.8.1 1998/11/12 03:06:21 heller Exp $
____________________________________________________________________________*/

#include <Timer.h>
#include <stddef.h>
#include "pgpMacMemory.h"
#include "MacFiles.h"

#include "CInterruptLevelTestMgr.h"
#include "CInterruptLevelFileTester.h"
#include "CInterruptLevelDRVRTester.h"



CInterruptLevelTestMgr::CInterruptLevelTestMgr( short fileRefNum )
	{
	mInProgress		= false;
	mFileRefNum		= fileRefNum;
	
	mNumTesters	= 0;
	pgpClearMemory( mTesters, sizeof( mTesters ) );
	}
	
	
	
CInterruptLevelTestMgr::~CInterruptLevelTestMgr( )
	{
	Stop();
	}



	
#pragma mark -

	
	void
CInterruptLevelTestMgr::AddTester( CInterruptLevelTester *tester)
	{
	pgpAssert( mNumTesters < kMaxTesters );
	
	mTesters[ mNumTesters ]	= tester;
	mNumTesters	+= 1;
	}
	
	
	void
CInterruptLevelTestMgr::CreateTesters( )
	{
	// create half of them as file testers
	for( ushort index = 0; index < kMaxTesters / 2; ++index )
		{
		AddTester( new CInterruptLevelFileTester( ) );
		}
		
	// and the other half as disk testers
	for( ushort index = 0; index < kMaxTesters / 2; ++index )
		{
		AddTester( new CInterruptLevelDRVRTester( ) );
		}
	}
	
	
	void
CInterruptLevelTestMgr::RunTesters( )
	{
	for( ushort index = 0; index < mNumTesters; ++index )
		{
		CInterruptLevelTester::IODirection	ioDirection;
		
		if ( (index & 1) != 0 )
			ioDirection	= CInterruptLevelTester::kReadDirection;
		else
			ioDirection	= CInterruptLevelTester::kWriteDirection;
		
		pgpAssert( IsntNull( mTesters[ index ] ) );
		
		mTesters[ index ]->Run( mFileRefNum, ioDirection);
		}
	}


	
	void
CInterruptLevelTestMgr::DeleteTesters( )
	{
	for( ushort index = 0; index < mNumTesters; ++index )
		{
		if ( IsntNull( mTesters[ index ] ) )
			{
			delete mTesters[ index ];
			mTesters[ index ]	= nil;
			}
		}
	
	mNumTesters	= 0;
	}
	
	

#pragma mark -
	
	void
CInterruptLevelTestMgr::Run( )
	{
	mInProgress	= TRUE;
	
	CreateTesters();
	RunTesters();
	}


	void
CInterruptLevelTestMgr::Stop( )
	{
	pgpAssert( mInProgress );
	
	if ( mInProgress )
		{
		OSErr	err	= noErr;
		
		DeleteTesters();
		mInProgress	= false;
		}
	}








