/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CPatcher.cp,v 1.4.8.1 1998/11/12 03:10:19 heller Exp $
____________________________________________________________________________*/

#include "CPatcher.h"



CPatcher::CPatcher()
	:	mOldRoutine(nil)
{
}


CPatcher::~CPatcher()
{
}



	void
CPatcher::Patch(
	SInt16			inTrapNum,
	ProcInfoType	inProcInfo,
	ProcPtr			inProc)
{
	UniversalProcPtr	theNewRoutine;

#if	TARGET_RT_MAC_CFM
	theNewRoutine =
		(UniversalProcPtr) ::NewRoutineDescriptor(	(ProcPtr) inProc,
													inProcInfo,
													GetCurrentArchitecture());
	PGPThrowIfNil_(theNewRoutine);
#else
	theNewRoutine = (UniversalProcPtr) inProc;
#endif

	if (inTrapNum & 0x0800){
		mOldRoutine = ::GetToolTrapAddress(inTrapNum);
		::SetToolTrapAddress(	(UniversalProcPtr) theNewRoutine,
								inTrapNum);
	} else {
		mOldRoutine = ::GetOSTrapAddress(inTrapNum);
		::SetOSTrapAddress(	(UniversalProcPtr) theNewRoutine,
							inTrapNum);
	}
}
