/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: COTInternetSocket.h,v 1.7.12.1 1998/11/12 03:22:31 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CInternetSocket.h"


class COTInternetSocket : public CInternetSocket {
public:
							COTInternetSocket();
	virtual 				~COTInternetSocket();

	virtual void			Bind(const PGPSocketAddressInternet *
									inAddress);
	virtual void			Close();
	
	virtual void			GetSocketName(PGPSocketAddressInternet * outName);

	virtual void			IOControlSocket(SInt32 inCommand,
								UInt32 * ioParam);

protected:
	EndpointRef				mEndpointRef;
	InetAddress				mBoundAddress;
	Boolean					mCanceled;
	
	virtual void			Cleanup();
	virtual void			DoBind(OTQLen inQLen);
	
	virtual Boolean			IsReadable();
	virtual Boolean			IsWriteable();
	virtual Boolean			IsError();

	virtual void			ThrowIfOTError(OSStatus inErr);
	
	static pascal void		NotifyProc(void* contextPtr, OTEventCode code, 
									   OTResult result, void* cookie);
};