/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CMacBinaryPipe.cp,v 1.3 1999/03/10 02:34:36 heller Exp $
____________________________________________________________________________*/
#include "PGPFoneUtils.h"
#include "PGPFMacUtils.h"
#include "CMacBinaryPipe.h"
#include "CControlThread.h"
#include "CPipe.h"
#include "FileWrapper.h"

#include <string.h>

#define READPICKUPSIZE 4096
#define WRITEPICKUPSIZE 8192

static binaryTypeRec smartBinRecs[]={
	{"PK", 2, 'pZIP', 'pZIP'},
	{"\x1F\x9D\x90", 3, 'LZIV', 'ZIVU'},
	{"MThd", 4, 'MIDI', 'Midi'},
	{"\x1A\x0A", 2, 'PAK ', 'PAK '},
	{"ZOO ", 4, 'BOOZ', 'ZOO '},
	{"GIF8", 4, 'JVWR', 'GIFf'},
	{"SIT!", 4, 'SIT!', 'SIT!'},
	{"\x01\x01", 2, 'CPCT', 'PACT'},
	{"\x1A\x08", 2, 'arc*', 'mArc'},
	{"\x1A\x09", 2, 'arc*', 'mArc'},
	{"\xFF\xD8\xFF\xE0\0\x10JFIF", 10, 'JVWR', 'JPEG'},
	{0,0,0,0}};
	
static long nonMacBinaryTypes[]={
	'TEXT', 'pZIP', 'ZIVU', 'Midi', 'PAK ', 'ZOO ', 'GIFf', 'mArc', 'JPEG', 
	PGPPARTIALFILETYPE, 0
	};

static void LogTransfer(XferInfo *xFile, short send, short good)
{
	xFile;
	send;
	good;
}

static OSErr CreateNewFileName(LThread *t, uchar *name, long *fileDirId, short *fileVolRef, long fileType)
{
	OSErr err;
	short existed=0, maxTries=256;
	short origLen;
	register short i;
	
	origLen=((uchar *)name)[0];
	while(existed<maxTries && (err=PGPFCreate(t, name, *fileDirId, *fileVolRef,
								PGPFONECREATOR, fileType, NIL, 0)))
	{
		if(err==dupFNErr)	// Duplicate Filename
		{
			existed++;
			i=origLen;
			name[++i]=' ';
			name[++i]='[';
			if(existed>=100)
				name[++i]='0'+(existed/100)%10;
			if(existed>=10)
				name[++i]='0'+(existed/10)%10;
			name[++i]='0'+existed%10;
			name[++i]=']';
			name[0]=i;
		}
		else if(err==fnfErr)	// File not found/created
		{
			*fileDirId=0;
			*fileVolRef=0;
		}
		else
			break;
	}
	return err;
}

void CheckSendMethod(LThread *t, XferInfo *xFile)
{
	HFileParam fileInfo;
	
	xFile->fatalErr=PGPFGetFInfo(t, xFile->file.name, xFile->file.parID,
			xFile->file.vRefNum, 0, &fileInfo, 1);
	if(!xFile->sendAs)
		xFile->bytesTotal=128+((fileInfo.ioFlLgLen+127) & ~127L)+
			((fileInfo.ioFlRLgLen+127) & ~127L);
	else
		xFile->bytesTotal=fileInfo.ioFlLgLen;
	xFile->fdType=fileInfo.ioFlFndrInfo.fdType;
	xFile->fdCreator=fileInfo.ioFlFndrInfo.fdCreator;
}

short SendFileAs(FSSpec *file, short remoteSystemType)
{
	OSErr result;
	HParamBlockRec fpb;
	short sendAs=0;
	
	fpb.ioParam.ioCompletion=NIL;
	fpb.ioParam.ioNamePtr=(uchar *)file->name;
	fpb.ioParam.ioVRefNum=file->vRefNum;
	fpb.fileParam.ioFDirIndex=0;
	fpb.fileParam.ioDirID=file->parID;
	result=PBHGetFInfoSync(&fpb);
	if(!result)
	{
		short noMBIndex;
		
		sendAs = 0;
		if(remoteSystemType != _pst_Macintosh)
			for(noMBIndex=0;nonMacBinaryTypes[noMBIndex];noMBIndex++)
				if(fpb.fileParam.ioFlFndrInfo.fdType == nonMacBinaryTypes[noMBIndex])
				{
					sendAs = 1;
					break;
				}
	}
	return sendAs;
}

CMacBinarySendPipe::CMacBinarySendPipe(XferInfo *xi, Boolean recovery, void **outResult)
        : LThread(FALSE, thread_DefaultStack, threadOption_UsePool, outResult)
{
	mXI = xi;
	mRecovery = recovery;
}

CMacBinarySendPipe::~CMacBinarySendPipe()
{
}

CMacBinaryReceivePipe::CMacBinaryReceivePipe(XferInfo *xi, void **outResult)
        : LThread(FALSE, thread_DefaultStack, threadOption_UsePool, outResult)
{
	mXI = xi;
}

CMacBinaryReceivePipe::~CMacBinaryReceivePipe()
{
}

long
CMacBinaryReceivePipe::WriteFork(short fileRef, long pos, long end)
{
	long count;
	char *data;
	OSErr err;
	
	while(!mXI->fatalErr && !mXI->pipe->DoPipeEnded() && (pos<end || end<0))
	{
		if(end<0 || (count=end-pos)>WRITEPICKUPSIZE)
			count=WRITEPICKUPSIZE;
		mXI->pipe->DoStartPipePull(&count, &data, 1);
#ifdef DEBUGXFERLOG
		DebugLog("\t\t\tWriteFork: Wrote %ld", count);
#endif
		if(err=PGPFWrite(this, fileRef, pos, &count, data, 1))
			mXI->fatalErr=err;
		else if(err=PGPFFlushFile(this, fileRef, 1))
			mXI->fatalErr=err;
		mXI->pipe->DoEndPipePull(-1);
		if(!mXI->fatalErr)
			pos+=count;
	}
	return pos;
}

static void
ReadMacBinaryHeader(MacBinaryHeader *macBin, XferInfo *xi, HFileParam *param,
					long *dataLen, long *resLen)
{
	//BlockMoveData(macBin->name, xi->file.name, nlen + 1);
	BlockMoveData(&macBin->dLength, dataLen, sizeof(macBin->dLength));
	BlockMoveData(&macBin->rLength, resLen, sizeof(macBin->rLength));
	BlockMoveData(&macBin->info1, &param->ioFlFndrInfo, sizeof(FInfo));
	param->ioFlFndrInfo.fdFlags &= 0xFF00;			// High byte
	param->ioFlFndrInfo.fdFlags |= macBin->info2;	// Low byte
	param->ioFlFndrInfo.fdFlags &= ~NOMODIFY;
	param->ioFlFndrInfo.fdLocation.h=0;
	param->ioFlFndrInfo.fdLocation.v=0;
	param->ioFlFndrInfo.fdFldr=0;
	BlockMoveData(&macBin->creation, &param->ioFlCrDat, sizeof(macBin->creation));
	BlockMoveData(&macBin->modification, &param->ioFlMdDat, sizeof(macBin->modification));
	xi->bytesTotal=128+((*dataLen+127) & ~127L)+((*resLen+127) & ~127L);
	xi->fdType = param->ioFlFndrInfo.fdType;
	xi->fdCreator = param->ioFlFndrInfo.fdCreator;
}

void *
CMacBinaryReceivePipe::Run()
{
	char macBinRecov[128];
	register MacBinaryHeader *macBin;
	register short i, j;
	uchar *p, c;
	ulong forkSize[2];
	ulong recoveryInfoOffset;
	long count=128, dataLen=0, resLen=0, useMB=0, startRes=0, startData=0;
	short dataRef=0, good=0, binType=-1, nlen;
	ushort crc;
	Boolean mbFileExists=FALSE;
	HFileParam param, param2;
	OSErr err;
	
	if(!PGPFGetFInfo(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 0, &param2, 1) &&
		(param2.ioFlFndrInfo.fdType==PGPPARTIALFILETYPE ||
				param2.ioFlFndrInfo.fdType==PGPMBPARTIALFILETYPE) &&
		param2.ioFlFndrInfo.fdCreator==PGPFONECREATOR)
	{
		if(param2.ioFlFndrInfo.fdType==PGPMBPARTIALFILETYPE)
		{
			useMB=1;
			recoveryInfoOffset=param2.ioFlLgLen-(128+sizeof(forkSize));
			PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
							fsRdWrPerm, &dataRef, 1);
			count=128;
			PGPFRead(this, dataRef, recoveryInfoOffset, &count, macBinRecov, 1);
			count=sizeof(forkSize);
			PGPFRead(this, dataRef, recoveryInfoOffset+128, &count, forkSize, 1);
			PGPFClose(this, dataRef, 1);
			startData=forkSize[0];
			startRes=forkSize[1];
			macBin=(MacBinaryHeader *)(macBinRecov-1);
			ReadMacBinaryHeader(macBin, mXI, &param, &dataLen, &resLen);
			pgpAssert(recoveryInfoOffset==((dataLen+127) & ~127L));
		}
		else
		{
			if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
							fsRdWrPerm, &dataRef, 1))
				goto error;
			startData=param2.ioFlLgLen;
		}
	}
	else
	{
		mXI->pipe->DoStartPipePull(&count, &p, 0);
		if(count)
		{
			macBin=(MacBinaryHeader *)(p-1);
			if(count<126 || p[0] || p[74] || p[82] ||
					(nlen=macBin->name[0])>63)
				goto noMB;
			BlockMoveData(&p[124], &crc, 2);
			if(macBin->minimumVersion <= 129 && crc==CalcCRC16(&p[0], 124))
				useMB = 2;
			else 
			{
				for (j = 101; j < 125; j++)
					if (p[j])
						goto noMB;
				useMB = 1;
			}
			if(useMB)
			{
				ReadMacBinaryHeader(macBin, mXI, &param, &dataLen, &resLen);
				recoveryInfoOffset=((dataLen+127) & ~127L);
			}
			else
			{
noMB:
				for(i=0;smartBinRecs[i].len;i++)
				{
					if(count>=smartBinRecs[i].len)
						if(!memcmp(smartBinRecs[i].ident, p, smartBinRecs[i].len))
						{
							binType=i;
							break;
						}
				}
				if(binType==-1)
				{
					for(i=0;i<count;i++)
					{
						c=(*(p+i)) & 0x7F;
						if(!(c==HT || c==CR || c==LF || c==ESC || (c>=' ' && c<='~')))
						{
							binType=-2;
							break;
						}
					}
				}
			}
			if(err=CreateNewFileName(this, mXI->file.name, &mXI->file.parID, &mXI->file.vRefNum,
						useMB ? PGPMBPARTIALFILETYPE : PGPPARTIALFILETYPE))
				goto error;
			if(useMB)
			{
				if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
								fsRdWrPerm, &dataRef, 1))
					goto error;
				if(err=PGPFSetEOF(this, dataRef, recoveryInfoOffset+128+sizeof(forkSize), 1))
					goto error;
				count=128;
				if(err=PGPFWrite(this, dataRef, recoveryInfoOffset, &count, p, 1))
					goto error;
				forkSize[0]=forkSize[1]=0;
				count=sizeof(forkSize);
				if(err=PGPFWrite(this, dataRef, recoveryInfoOffset+128, &count, forkSize, 1))
					goto error;
				if(err=PGPFFlushFile(this, dataRef, 1))
					goto error;
				PGPFClose(this, dataRef, 1);
				dataRef=0;
				if(err=PGPFOpenRF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
								fsRdWrPerm, &dataRef, 1))
					goto error;
				if(err=PGPFSetEOF(this, dataRef, ((resLen+127) & ~127L), 1))
					goto error;
				PGPFClose(this, dataRef, 1);
				dataRef=0;
				if(mXI->fatalErr)
					goto error;
				mbFileExists=TRUE;
			}
			else
			{
				if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
								fsRdWrPerm, &dataRef, 1))
					goto error;
				if(mXI->bytesTotal && count>mXI->bytesTotal)
					count=mXI->bytesTotal;
				if(err=PGPFWrite(this, dataRef, -1, &count, p, 1))
					mXI->fatalErr=err;
				startData=count;
			}
		}
		mXI->pipe->DoEndPipePull(-1);
	}
	mXI->forceUpdate=1;
	if(startRes)
		goto writerfork;
	if(useMB)
	{
		if(dataLen)
		{
			if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
							fsRdWrPerm, &dataRef, 1))
				goto error;
			forkSize[0]=WriteFork(dataRef, startData, ((dataLen+127) & ~127L));
			PGPFClose(this, dataRef, 1);
			dataRef=0;
		}
writerfork:
		if(resLen && !mXI->fatalErr)
		{
			if(err=PGPFOpenRF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
							fsRdWrPerm, &dataRef, 1))
				goto error;
			forkSize[1]=WriteFork(dataRef, startRes, ((resLen+127) & ~127L));
			if(!mXI->fatalErr)
				err=PGPFSetEOF(this, dataRef, resLen, 1);
			PGPFClose(this, dataRef, 1);
			dataRef=0;
		}
	}
	else
	{
		forkSize[0]=WriteFork(dataRef, startData, mXI->bytesTotal);
		if(mXI->bytesTotal && !mXI->fatalErr && mXI->setEOF)
			err=PGPFSetEOF(this, dataRef, mXI->bytesTotal, 1);
		PGPFClose(this, dataRef, 1);
		dataRef=0;
	}
	if(!mXI->pipe->DoPipeAborted())
	{
		if(useMB)
		{
			if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
							fsRdWrPerm, &dataRef, 1))
				goto error;
			if(err=PGPFSetEOF(this, dataRef, dataLen, 1))
				goto error;
			PGPFClose(this, dataRef, 1);
			dataRef=0;
		}
		else
		{
			switch(binType)
			{
				case -1:
					param.ioFlFndrInfo.fdType='TEXT';
					param.ioFlFndrInfo.fdCreator=gPGFOpts.fopt.textFileCreator;
					break;
				case -2:
					param.ioFlFndrInfo.fdType='BIN ';
					param.ioFlFndrInfo.fdCreator='BIN ';
					break;
				default:
					param.ioFlFndrInfo.fdType=smartBinRecs[binType].type;
					param.ioFlFndrInfo.fdCreator=smartBinRecs[binType].creator;
			}
			param.ioFlCrDat=param.ioFlMdDat=LMGetTime();
			param.ioFlFndrInfo.fdFlags=0;
			param.ioFlFndrInfo.fdLocation.h=0;
			param.ioFlFndrInfo.fdLocation.v=0;
			param.ioFlFndrInfo.fdFldr=0;
		}
		PGPFSetFInfo(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, &param, 0);
		good=1;
	}
	else
		goto error;
		// PGPFDelete(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 0);
	LogTransfer(mXI, 0, good);
#ifdef DEBUGXFERLOG
	DebugLog("\t\t\tCMacBinaryReceivePipe: Success");
#endif
	mXI->pipe->DoAckEndPipe();
	return (void *)1L;
error:
	if(dataRef)
		PGPFClose(this, dataRef, 1);
	LogTransfer(mXI, 0, good);
	if(mbFileExists)
	{
		PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
						fsRdWrPerm, &dataRef, 1);
		count=8;
		PGPFWrite(this, dataRef, recoveryInfoOffset+128, &count, forkSize, 1);
		PGPFFlushFile(this, dataRef, 1);
		PGPFClose(this, dataRef, 1);
	}
	mXI->fatalErr=err;
#ifdef DEBUGXFERLOG
	DebugLog("\t\t\tCMacBinaryReceivePipe: Failure");
#endif
	mXI->pipe->DoAbortPipe();
	return (void *)1L;
}

long
CMacBinarySendPipe::ReadFork(short fileRef, long offset, long start, long end)
{
	long count, pos=start, padRead;
	char *data;
	OSErr err;
	register short i;
	
	while(!mXI->pipe->DoPipeEnded() && pos<end)
	{
		if(mXI->pipe->DoPipePosChanged(&count))
		{
			pos=count-offset;
			if(pos<0 || pos>=end)
				return count;
		}
		if((count=end-pos)>READPICKUPSIZE)
			count=READPICKUPSIZE;
		padRead=count;
		mXI->pipe->DoStartPipePush(count, &data);
		if(err=PGPFRead(this, fileRef, pos, &count, data, 1))
			if(err!=eofErr)
				mXI->fatalErr=err;
		if(padRead>count)
			for(i=count;i<padRead;i++)
				data[i]=0;
		pos+=padRead;
		mXI->pipe->DoEndPipePush(-1);
#ifdef DEBUGXFERLOG
		DebugLog("\t\t\tReadFork: Read %ld", count);
#endif
	}
	return -1;
}

void *
CMacBinarySendPipe::Run()
{
	HFileParam fileInfo;
	char *data;
	short useMB, dataRefD=0, dataRefR=0, temp;
	uchar MBHeader[128];
	ulong forkSize[2];
	MacBinaryHeader *s;
	long pipePos=0, startData, startRes, count;
	OSErr err;
	
	if(!(mXI->fatalErr=PGPFGetFInfo(this, mXI->file.name, mXI->file.parID,
										mXI->file.vRefNum, 0, &fileInfo, 1)))
	{
startSend:
		useMB=0;
		if(!mXI->sendAs)
		{
			useMB=1;
			startData=startRes=0;
			if(pipePos<128)
			{
				if(mRecovery && (fileInfo.ioFlFndrInfo.fdType==PGPMBPARTIALFILETYPE) &&
					(fileInfo.ioFlFndrInfo.fdCreator==PGPFONECREATOR))
				{
					if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum,
										fsRdPerm, &dataRefD, 1))
						goto error;
					count=128;
					if(err=PGPFRead(this, dataRefD, fileInfo.ioFlLgLen-(128+sizeof(forkSize)), &count, MBHeader, 1))
						goto error;
					count=sizeof(forkSize);
					if(err=PGPFRead(this, dataRefD, fileInfo.ioFlLgLen-sizeof(forkSize), &count, forkSize, 1))
						goto error;
					PGPFClose(this, dataRefD, 1);
					dataRefD=0;
				}
				else
				{
					s=(MacBinaryHeader *)(MBHeader-1);
					memset(MBHeader, 0, 128);
					pstrcpy(s->name, mXI->file.name);
					s->info2=fileInfo.ioFlFndrInfo.fdFlags & 0x00FF;
					fileInfo.ioFlFndrInfo.fdFlags &= 0xFF00;
					*(long *)&fileInfo.ioFlFndrInfo.fdLocation = 0;
					fileInfo.ioFlFndrInfo.fdFldr = 0;
					s->info1=fileInfo.ioFlFndrInfo;
					s->dLength=fileInfo.ioFlLgLen;
					s->rLength=fileInfo.ioFlRLgLen;
					forkSize[0]=(fileInfo.ioFlLgLen+127) & ~127L;
					forkSize[1]=(fileInfo.ioFlRLgLen+127) & ~127L;
					s->creation=fileInfo.ioFlCrDat;
					s->modification=fileInfo.ioFlMdDat;
					s->newVersion=129;
					s->minimumVersion=129;
					temp=CalcCRC16(&MBHeader[0], 124);
					BlockMoveData(&temp, &MBHeader[124], 2);
				}
				mXI->pipe->DoStartPipePush(128-pipePos, &data);
				BlockMoveData(MBHeader+pipePos, data, 128-pipePos);
				mXI->pipe->DoEndPipePush(-1);
			}
			else if(pipePos<128+forkSize[0])
				startData=pipePos-128;
			else
			{
				startData=forkSize[0];
				startRes=pipePos-128-startData;
			}
		}
		if(useMB)
		{
			if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum,
								fsRdPerm, &dataRefD, 1))
				goto error;
			if(err=PGPFOpenRF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum,
								fsRdPerm, &dataRefR, 1))
				goto error;
			if(fileInfo.ioFlLgLen)
			{
				pipePos=ReadFork(dataRefD, 128, startData, forkSize[0]);
				if(pipePos>=0)
					goto startSend;
			}
			if(fileInfo.ioFlRLgLen)
			{
				pipePos=ReadFork(dataRefR, 128+forkSize[0], startRes, forkSize[1]);
				if(pipePos>=0)
					goto startSend;
			}
			PGPFClose(this, dataRefD, 1);
			PGPFClose(this, dataRefR, 1);
			dataRefD=dataRefR=0;
		}
		else
		{
			forkSize[0]=fileInfo.ioFlLgLen;
			if(err=PGPFOpenDF(this, mXI->file.name, mXI->file.parID, mXI->file.vRefNum, 
							fsRdPerm, &dataRefD, 1))
				goto error;
			ReadFork(dataRefD, 0, 0, forkSize[0]);
			PGPFClose(this, dataRefD, 1);
			dataRefD=0;
		}
		if(mXI->pipe->DoEndPipe(&pipePos))
			goto startSend;
		LogTransfer(mXI, 1, (mXI->fatalErr==0));
#ifdef DEBUGXFERLOG
		DebugLog("\t\t\tCMacBinarySendPipe: Success");
#endif
	}
	else
		mXI->pipe->DoAbortPipe();
	return (void *)1L;
error:
	if(dataRefD)
		PGPFClose(this, dataRefD, 1);
	if(dataRefR)
		PGPFClose(this, dataRefR, 1);
	mXI->fatalErr=err;
	mXI->pipe->DoAbortPipe();
	return (void *)1L;
}

