/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFWindow.h,v 1.6 1999/03/10 02:36:23 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LWindow.h>
#include <LListener.h>
#include <LPeriodical.h>
#include <Threads.h>
#include <Sound.h>

#include "CPFTransport.h"

class CStatusPane;
class CControlThread;
class CSoundInput;
class CSoundOutput;
class CMessageQueue;
class CXferWindow;
class CPFDirectoryWindow;
class CPopupList;
class LDisclosureTriangle;
class LBevelButton;
class LCicnButton;
class LCaption;
class LEditText;
struct DirectoryEntry;

class CPFWindow		:	public LWindow,
						public LListener,
						public LPeriodical
{
public:
	enum { class_ID = 'PGwi' };
						CPFWindow();
						CPFWindow(LStream *inStream);
						~CPFWindow();
	static CPFWindow*	CreateCPFWindowStream(LStream *inStream);
	void				ListenToMessage(MessageT inMessage, void *ioParam);
	void				FinishCreateSelf();
	Boolean				HandleKeyPress(const EventRecord	&inKeyEvent);
	
	CControlThread		*GetControlThread()	{	return mControlThread;	}
	CMessageQueue		*GetControlQueue()	{	return mControlQueue;	}
	void				ShowAuthParams(char *params);
	void				HideAuthParams();
	void				SetState(enum CSTypes newState);
	enum CSTypes		GetState();
	void				SetSpeaker(Boolean speaker, Boolean fullDuplex);
	void				SetSubs(LWindow *authWindow, LWindow *xferWindow);
	void				SpendTime(const EventRecord &inMacEvent);
	void				ShowStatus(void);
	void				SetDecoder(ulong coder);
	void				SetDecoderList(uchar *decoders, short numDecoders);
	void				ClearDecoderList();
	void				SetEncoderList(uchar *encoders, short numEncoders);
	void				ClearEncoderList();
	void				SetEncoder(ulong coder);
	void				SetEncryption(ulong cryptor1, ulong cryptor2);
	void				ModifiersChanged(ushort modifiers);
	void				SetSoundInStatus(Boolean sending);
	void				ShowCaller();
	void				SetLocalAddress(uchar *localAddr);
	void				AllowXfers(Boolean allow);
	void				SetKeyExchange(char *exchangeStr);
	Boolean				AllowSubRemoval(LCommander	*inSub);
	void				DirectoryCall(DirectoryEntry *dirEntry);
	void				AECall( Str255	phone );
private:
	enum CSTypes			mState;
	Boolean					mSpeaker, mSoundInOn, mFullDuplex, mStatUpdate, mSIUpdate;
	long					mControlResult, mSoundInputResult, mSoundOutputResult,
							mRegistryResult;
	CXferWindow				*mXferWindow;
	CPFDirectoryWindow		*mDirWindow;
	CMessageQueue			*mControlQueue;
	LBevelButton			*mConButton, *mTalkButton;
	LDisclosureTriangle		*mIntermTriangle, *mAdvancedTriangle;
	LBevelButton			*mDirectoryButton;
	LCicnButton				*mSoundInIcon, *mXferButton;
	LEditText				*mNumberEdit;
	LCaption				*mStatusCaption, *mEncryptCaption,
							*mRIDCaption, *mRIDTitleCaption,
							*mLocalCaption, *mAddrCaption,
							*mExchangeCaption;
	CControlThread			*mControlThread;
	CSoundInput				*mSoundInput;
	CSoundOutput			*mSoundOutput;
	LWindow					*mAuthWindow;
	CPopupList				*mDecoderPopup, *mEncoderPopup;
	uchar					mLocalAddress[32];
	ulong					mVoiceDecoders[32], mDecoder, mCryptor;
	short					mNumDecoders;
	ulong					mVoiceEncoders[32], mEncoder;
	short					mNumEncoders;
	ushort					mModifierKeys;
};

