/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CTriThreshold.cp,v 1.4 1999/03/10 02:41:39 heller Exp $
____________________________________________________________________________*/
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <Threads.h>
#include <UDrawingState.h>

#include "CTriThreshold.h"

#include "PGPFoneUtils.h"

const RGBColor cBlue = { 0xCCCC, 0xCCCC, 0xFFFF };

CTriThreshold *CTriThreshold::CreateTriThresholdStream(LStream *inStream)
{
	return (new CTriThreshold(inStream));
}

CTriThreshold::CTriThreshold()
{
}

CTriThreshold::CTriThreshold(LStream *inStream)
		: LControl(inStream)
{
	mValue = 0;
	mPosition = 0;
	mTriangleToDraw = ::OpenPoly();
	::MoveTo(0,5);
	::LineTo(10, 5);
	::LineTo(5, 0);
	::LineTo(0, 5);
	::ClosePoly();
}

CTriThreshold::~CTriThreshold()
{
	::KillPoly(mTriangleToDraw);
}

void
CTriThreshold::ClickSelf(const SMouseDownEvent &inMouseDown)
{
	Rect frame;
	Point curMouse, oldMouse;
	
	CalcLocalFrameRect(frame);
	FocusDraw();
	ApplyForeAndBackColors();
	oldMouse = curMouse = inMouseDown.whereLocal;
	while(::StillDown())
	{
		::GetMouse(&curMouse);
		if(curMouse.h != oldMouse.h)
		{
			EraseRect(&frame);
			mPosition = curMouse.h - frame.left - 4;
			if(mPosition < 0)
				mPosition = 0;
			if(mPosition > frame.right-frame.left-11)
				mPosition = frame.right-frame.left-11;
			Draw(NIL);
			oldMouse = curMouse;
		}
		::YieldToAnyThread();
	}
	Draw(NIL);
	//positions are from 0-47
	//we convert this to a # from 0-32767
	mValue = mPosition * 697;
	BroadcastValueMessage();
}

void
CTriThreshold::DrawSelf()
{
	Rect frame;
	
	if(FocusDraw())
	{
		CalcLocalFrameRect(frame);
		::RGBForeColor(&cBlue);
		::OffsetPoly(mTriangleToDraw, frame.left+mPosition, frame.top);
		::FillPoly(mTriangleToDraw, &(UQDGlobals::GetQDGlobals()->black));
		ApplyForeAndBackColors();
		::FramePoly(mTriangleToDraw);
		::OffsetPoly(mTriangleToDraw, -(frame.left+mPosition), -frame.top);
	}
}

Int32
CTriThreshold::GetValue() const
{
	return mValue;
}

void
CTriThreshold::SetValue(
	Int32	inValue)
{
	mPosition = inValue / 697;
	mValue = inValue;
	DrawSelf();
	BroadcastValueMessage();
}

