/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

 */

#include <sys/types.h>

#include "shell.h"
#include "pgplib.h"

void
verify (int argc, char *argv[])
{

    u_quad_t	key_id;
    keyent_t	**contents;
    PGPpubkey_t	*keyp, *tmpkey;
    PGPuserid_t	**uidpp, **tmpuidp;
    int		num_uid;
    int		index;
    int		have_key, counter, sig_ok;
    /* scratch */
    int		i;

    if ( argc != 2 ) {
	fprintf(stderr, "VERIFY KeyID 0x1234567890123456\n");
	return;
    }

    i = sscanf(argv[1], "%qx", &key_id);
    if ( i != 1 ) {
	fprintf(stderr, "VERIFY 0x1234567890123456\n");
	return;
    }

    i = get_keycontents(key_id, &contents);
    switch (i) {
    case  0: break;
    case  1: fprintf(stderr, "No such key\n"); 
	return;
    case -1: fprintf(stderr, "Some error getting key contents\n"); 
	return;
    default: assert(0);
    }

    /* **************************************************************
     * We walk through the contents, we pick up the key on the way (it
     * is supposted to be the first item).
     * ************************************************************** */

    keyp = NULL;
    uidpp = calloc(1, sizeof( PGPuserid_t *));
    num_uid = 0;
    have_key = 0;
    for(index=0; contents[index] != NULL; index++) {
	switch (contents[index]->what) {
	default :
	    assert(0);
	case PUBKEY:
	    if ( have_key == 1 ) {
		fprintf(stderr, "Found key %#.16llx, have %#.16llx\n",
			contents[index]->u.sig->key_id, 
			BN_get_keyid(keyp->N));
	    }
	    have_key = 1;
	    keyp = contents[index]->u.key;

	    continue;

	case UID:
	    /* Add this UID to the ones we already have, maintain
	     * NULL termination. */
	    tmpuidp = realloc(uidpp, (num_uid+2) * sizeof(PGPuserid_t*));
	    uidpp = tmpuidp;
	    uidpp[num_uid+1] = NULL;
	    uidpp[num_uid] = contents[index]->u.uid;
	    fprintf(stdout, "\tUID: %s\n", uidpp[num_uid]->name);

	    num_uid += 1;
	    continue;

	case SIG: 
	    
	    /* Start at the _end_ and verify towards the start
	     * until we find something that matches.
	     * But first, we fetch the key that made the signature.
	     */
	    tmpkey = NULL;
	    i = fetch_only_pubkey(contents[index]->u.sig->key_id, &tmpkey);
	    if ( i == -1 ) {
		fprintf(stderr, "Error getting pubkey\n");
		fprintf(stdout, "Error getting pubkey\n");
	    }
	    if ( i == 1 ) {
		fprintf(stdout, "\t\tSig: Unknown key, can not verify\n");
		continue;
	    }
	    sig_ok = 0; 
	    /* we have a pubkey that made a UID, a pubkey, signature, a 
	     * pubkey that made the signature.  Check it out.
	     */
	    for(counter=num_uid-1; 
		counter >= 0 && uidpp[counter] != NULL; 
		counter -= 1) 
	    {
		i = verify_keysig(keyp, 
				  uidpp[counter], 
				  contents[index]->u.sig,
				  tmpkey);
		if ( i == -1 ) {
		    fprintf(stderr, "Error veryfiyng signature\n");
		    return;
		}
		if ( i == 1 ) {
		    fprintf(stdout, "Didn't verify OK\n");
		    /* not this UID, at least */
		    continue;
		}
		free_pubkey(tmpkey);
		free(tmpkey);
		fprintf(stdout, "\t\tSig with %#.16llx OK\n",
			contents[index]->u.sig->key_id);
		/* find out who this key belongs to */
		i = find_uids_with_key(contents[index]->u.sig->key_id, 
				       &tmpuidp);
		if ( i == -1 ) {
		    fprintf(stderr, "Some internal error\n");
		    return;
		}
		if ( i == 1 )
		    fprintf(stdout, "\t\t\tNo matching UID\n");
		else {
		    assert(i==0);
		    for(i=0; tmpuidp[i] != NULL; i++) {
			fprintf(stdout, "\t\t\t%s\n", tmpuidp[i]->name);
			free_uid(tmpuidp[i]);
		    }
		    free(tmpuidp);
		}
		sig_ok = 1;
		
		break;
	    }
	} /* switch */
    } /* for (we have gone through the entire thing */
    free_keyrecords(contents);
}
