/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SymmetricCipher;

public final class IDEA
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel((String)"IDEA");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("IDEA", 2, 3);
    private long native_cookie;
    private Object native_lock;
    private static final int ROUNDS = 8;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 16;
    private static final int INTERNAL_KEY_LENGTH = 52;
    private short[] ks = new short[52];
    private static final byte[][][] tests = new byte[][][]{new byte[][]{{0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8}, {0, 0, 0, 1, 0, 2, 0, 3}, {17, -5, -19, 43, 1, -104, 109, -27}}, new byte[][]{{58, -104, 78, 32, 0, 25, 93, -77, 46, -27, 1, -56, -60, 124, -22, 96}, {1, 2, 3, 4, 5, 6, 7, 8}, {-105, -68, -40, 32, 7, -128, -38, -122}}, new byte[][]{{0, 100, 0, -56, 1, 44, 1, -112, 1, -12, 2, 88, 2, -68, 3, 32}, {5, 50, 10, 100, 20, -56, 25, -6}, {101, -66, -121, -25, -94, 83, -118, -19}}};

    private static void debug(String string) {
        err.println("IDEA: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(IDEA.getLibMajorVersion(), IDEA.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail((Throwable)unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    IDEA.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                IDEA.debug("Using native library? " + (this.native_lock != null));
            }
            return;
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    public IDEA() {
        super(false, false, "Cryptix");
        this.link();
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    IDEA.debug(String.valueOf(string) + " in native_finalize");
                }
                return;
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return 8;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
        this.invertKey();
    }

    protected int engineUpdate(byte[] object, int n, int n2, byte[] byArray, int n3) {
        Object object2;
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n < 0 || (long)n + (long)n2 > (long)((byte[])object).length || n3 < 0 || (long)n3 + (long)n2 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(String.valueOf(this.getAlgorithm()) + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n, byArray, n3, bl) == 0) {
                        throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Error in native code");
                    }
                    n += 8;
                    n3 += 8;
                    ++n5;
                }
            }
        } else if (bl) {
            int n6 = 0;
            while (n6 < n4) {
                this.blockEncrypt((byte[])object, n, byArray, n3);
                n += 8;
                n3 += 8;
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n4) {
                this.blockDecrypt((byte[])object, n, byArray, n3);
                n += 8;
                n3 += 8;
                ++n7;
            }
        }
        return n2;
    }

    private void makeKey(Key key) throws InvalidKeyException, CryptixException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var4_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        IDEA.debug(String.valueOf(error) + ". Will use 100% Java.");
                    }
                }
            }
        }
        this.ks[0] = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.ks[1] = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.ks[2] = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.ks[3] = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.ks[4] = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.ks[5] = (short)((byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF);
        this.ks[6] = (short)((byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF);
        this.ks[7] = (short)((byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF);
        int n = 0;
        int n2 = 0;
        int n3 = 8;
        while (n3 < 52) {
            this.ks[++n + 7 + n2] = (short)(this.ks[(n & 7) + n2] << 9 | this.ks[(n + 1 & 7) + n2] >>> 7 & 0x1FF);
            n2 += n & 8;
            n &= 7;
            ++n3;
        }
    }

    private void invertKey() {
        if (this.native_lock == null) {
            int n = 4;
            int n2 = 51;
            short[] sArray = new short[52];
            sArray[n2--] = IDEA.inv(this.ks[3]);
            sArray[n2--] = -this.ks[2];
            sArray[n2--] = -this.ks[1];
            sArray[n2--] = IDEA.inv(this.ks[0]);
            int n3 = 1;
            while (n3 < 8) {
                sArray[n2--] = this.ks[n + 1];
                sArray[n2--] = this.ks[n];
                sArray[n2--] = IDEA.inv(this.ks[n + 5]);
                sArray[n2--] = -this.ks[n + 3];
                sArray[n2--] = -this.ks[n + 4];
                sArray[n2--] = IDEA.inv(this.ks[n + 2]);
                ++n3;
                n += 6;
            }
            sArray[n2--] = this.ks[n + 1];
            sArray[n2--] = this.ks[n];
            sArray[n2--] = IDEA.inv(this.ks[n + 5]);
            sArray[n2--] = -this.ks[n + 4];
            sArray[n2--] = -this.ks[n + 3];
            sArray[n2--] = IDEA.inv(this.ks[n + 2]);
            System.arraycopy(sArray, 0, this.ks, 0, 52);
        }
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        short s;
        short s2 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        short s3 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        short s4 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        short s5 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
        int n3 = 0;
        int n4 = 8;
        while (n4-- > 0) {
            s2 = IDEA.mul(s2, this.ks[n3++]);
            s3 = (short)(s3 + this.ks[n3++]);
            s4 = (short)(s4 + this.ks[n3++]);
            s5 = IDEA.mul(s5, this.ks[n3++]);
            short s6 = s4;
            s4 = IDEA.mul(s2 ^ s4, this.ks[n3++]);
            s = s3;
            s3 = IDEA.mul(s4 + (s3 ^ s5), this.ks[n3++]);
            s4 = (short)(s4 + s3);
            s2 = (short)(s2 ^ s3);
            s5 = (short)(s5 ^ s4);
            s3 = (short)(s3 ^ s6);
            s4 = (short)(s4 ^ s);
        }
        s = IDEA.mul(s2, this.ks[n3++]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s;
        s = (short)(s4 + this.ks[n3++]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s;
        s = (short)(s3 + this.ks[n3++]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s;
        s = IDEA.mul(s5, this.ks[n3]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2] = (byte)s;
    }

    private void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.blockEncrypt(byArray, n, byArray2, n2);
    }

    private static short mul(int n, int n2) {
        n2 &= 0xFFFF;
        if ((n &= 0xFFFF) != 0) {
            if (n2 != 0) {
                int n3 = n * n2;
                return (short)(n2 - n + ((n2 = n3 & 0xFFFF) < (n = n3 >>> 16) ? 1 : 0));
            }
            return (short)(1 - n);
        }
        return (short)(1 - n2);
    }

    private static short inv(short s) {
        int n = s & 0xFFFF;
        if (n <= 1) {
            return (short)n;
        }
        int n2 = 65537 / n;
        int n3 = 65537 % n;
        if (n3 == 1) {
            return (short)(1 - n2);
        }
        int n4 = 1;
        do {
            int n5 = n / n3;
            n4 += n5 * n2;
            if ((n %= n3) == 1) {
                return (short)n4;
            }
            n5 = n3 / n;
            n2 += n5 * n4;
        } while ((n3 %= n) != 1);
        return (short)(1 - n2);
    }

    public static void main(String[] stringArray) {
        try {
            IDEA.self_test();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static void self_test() throws Throwable {
        Cipher cipher = Cipher.getInstance((String)"IDEA", (String)"Cryptix");
        int n = 0;
        while (n < tests.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", tests[n][0]);
            cipher.initEncrypt((Key)rawSecretKey);
            byte[] byArray = cipher.crypt(tests[n][1]);
            if (!ArrayUtil.areEqual((byte[])tests[n][2], (byte[])byArray)) {
                throw new CryptixException("encrypt #" + n + " failed");
            }
            cipher.initDecrypt((Key)rawSecretKey);
            byArray = cipher.crypt(tests[n][2]);
            if (!ArrayUtil.areEqual((byte[])tests[n][1], (byte[])byArray)) {
                throw new CryptixException("decrypt #" + n + " failed");
            }
            ++n;
        }
        if (debuglevel > 0) {
            IDEA.debug("Self-test OK");
        }
    }
}

