/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.DecryptException;
import cryptix.pgp.KeyClient;
import cryptix.pgp.KeyID;
import cryptix.pgp.KeyStore;
import cryptix.pgp.Passphrase;
import cryptix.pgp.PublicKeyRing;
import cryptix.pgp.SecretKeyRing;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.SecretKey;
import cryptix.util.EmailAddress;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Vector;

public final class KeyGlob
extends KeyStore {
    private Vector publicKeyRings = new Vector();
    private Vector secretKeyRings = new Vector();
    private KeyClient keyClient = null;

    public void addKeyRing(PublicKeyRing publicKeyRing) {
        this.publicKeyRings.addElement(publicKeyRing);
    }

    public void addKeyRing(SecretKeyRing secretKeyRing) {
        this.secretKeyRings.addElement(secretKeyRing);
    }

    public void setKeyServer(KeyClient keyClient) throws IOException, UnknownHostException {
        this.keyClient = keyClient;
    }

    public int getKeyTrust(KeyID keyID, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.publicKeyRings.size()) {
                PublicKeyRing publicKeyRing = (PublicKeyRing)this.publicKeyRings.elementAt(n);
                int n2 = publicKeyRing.getKeyTrust(keyID);
                if (n2 != -1) {
                    return n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.secretKeyRings.size()) {
                SecretKeyRing secretKeyRing = (SecretKeyRing)this.secretKeyRings.elementAt(n);
                int n3 = secretKeyRing.getKeyTrust(keyID);
                if (n3 != -1) {
                    return n3;
                }
                ++n;
            }
        }
        return -1;
    }

    public PublicKey getKey(String string) throws IOException {
        PublicKey publicKey = null;
        int n = 0;
        while (n < this.publicKeyRings.size()) {
            publicKey = ((PublicKeyRing)this.publicKeyRings.elementAt(n)).getKey(string);
            if (publicKey != null) {
                return publicKey;
            }
            ++n;
        }
        if (this.keyClient != null) {
            return this.keyClient.getKey(string);
        }
        return null;
    }

    public PublicKey getKey(KeyID keyID) throws IOException {
        PublicKey publicKey = null;
        int n = 0;
        while (n < this.publicKeyRings.size()) {
            publicKey = ((PublicKeyRing)this.publicKeyRings.elementAt(n)).getKey(keyID);
            if (publicKey != null) {
                return publicKey;
            }
            ++n;
        }
        if (this.keyClient != null) {
            return this.keyClient.getKey(keyID);
        }
        return null;
    }

    public PublicKey getKey(EmailAddress emailAddress) throws IOException {
        PublicKey publicKey = null;
        int n = 0;
        while (n < this.publicKeyRings.size()) {
            publicKey = ((PublicKeyRing)this.publicKeyRings.elementAt(n)).getKey(emailAddress);
            if (publicKey != null) {
                return publicKey;
            }
            ++n;
        }
        if (this.keyClient != null) {
            return this.keyClient.getKey(emailAddress);
        }
        return null;
    }

    public SecretKey getSecretKey(String string, Passphrase passphrase) throws IOException, DecryptException {
        SecretKey secretKey = null;
        int n = 0;
        while (n < this.secretKeyRings.size()) {
            secretKey = ((SecretKeyRing)this.secretKeyRings.elementAt(n)).getKey(string, passphrase);
            if (secretKey != null) {
                return secretKey;
            }
            ++n;
        }
        return null;
    }

    public SecretKey getSecretKey(KeyID keyID, Passphrase passphrase) throws IOException, DecryptException {
        SecretKey secretKey = null;
        int n = 0;
        while (n < this.secretKeyRings.size()) {
            secretKey = ((SecretKeyRing)this.secretKeyRings.elementAt(n)).getKey(keyID, passphrase);
            if (secretKey != null) {
                return secretKey;
            }
            ++n;
        }
        return null;
    }

    public String getUserName(KeyID keyID) {
        String string = null;
        int n = 0;
        while (n < this.publicKeyRings.size()) {
            string = ((PublicKeyRing)this.publicKeyRings.elementAt(n)).getUserName(keyID);
            if (string != null) {
                return string;
            }
            ++n;
        }
        return keyID.toString();
    }
}

