/*
 * Decompiled with CFR 0.152.
 */
package DEAL;

import DEAL.DEAL_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class DES_Algorithm {
    static final String NAME = "DES_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err;
    static final boolean TRACE;
    private static final int ROUNDS = 16;
    private static final int BLOCK_SIZE = 8;
    private static final int[] SKB;
    private static final int[] SP_TRANS;
    private static final char[] HEX_DIGITS;

    static void debug(String string) {
        ((PrintWriter)null).println(">>> DES_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> DES_Algorithm." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        int n = 0;
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = (n3 >>> 4 ^ n2) & 0xF0F0F0F;
        n2 ^= n4;
        n3 ^= n4 << 4;
        n4 = (n2 << 18 ^ n2) & 0xCCCC0000;
        n2 ^= n4 ^ n4 >>> 18;
        n4 = (n3 << 18 ^ n3) & 0xCCCC0000;
        n3 ^= n4 ^ n4 >>> 18;
        n4 = (n3 >>> 1 ^ n2) & 0x55555555;
        n2 ^= n4;
        n3 ^= n4 << 1;
        n4 = (n2 >>> 8 ^ n3) & 0xFF00FF;
        n3 ^= n4;
        n2 ^= n4 << 8;
        n4 = (n3 >>> 1 ^ n2) & 0x55555555;
        n3 ^= n4 << 1;
        n3 = (n3 & 0xFF) << 16 | n3 & 0xFF00 | (n3 & 0xFF0000) >>> 16 | ((n2 ^= n4) & 0xF0000000) >>> 4;
        n2 &= 0xFFFFFFF;
        int n5 = 0;
        int[] nArray = new int[32];
        n = 0;
        while (n < 16) {
            if ((32508 >> n & 1) == 1) {
                n2 = (n2 >>> 2 | n2 << 26) & 0xFFFFFFF;
                n3 = (n3 >>> 2 | n3 << 26) & 0xFFFFFFF;
            } else {
                n2 = (n2 >>> 1 | n2 << 27) & 0xFFFFFFF;
                n3 = (n3 >>> 1 | n3 << 27) & 0xFFFFFFF;
            }
            int n6 = SKB[n2 & 0x3F] | SKB[0x40 | (n2 >>> 6 & 3 | n2 >>> 7 & 0x3C)] | SKB[0x80 | (n2 >>> 13 & 0xF | n2 >>> 14 & 0x30)] | SKB[0xC0 | (n2 >>> 20 & 1 | n2 >>> 21 & 6 | n2 >>> 22 & 0x38)];
            n4 = SKB[0x100 | n3 & 0x3F] | SKB[0x140 | (n3 >>> 7 & 3 | n3 >>> 8 & 0x3C)] | SKB[0x180 | n3 >>> 15 & 0x3F] | SKB[0x1C0 | (n3 >>> 21 & 0xF | n3 >>> 22 & 0x30)];
            nArray[n5++] = n4 << 16 | n6 & 0xFFFF;
            n6 = n6 >>> 16 | n4 & 0xFFFF0000;
            nArray[n5++] = n6 << 4 | n6 >>> 28;
            ++n;
        }
        return nArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[] nArray = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24};
        DES_Algorithm.IP(nArray);
        DES_Algorithm.encrypt(nArray, object);
        DES_Algorithm.FP(nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        byte[] byArray2 = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24), (byte)n3, (byte)(n3 >> 8), (byte)(n3 >> 16), (byte)(n3 >> 24)};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[] nArray = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24};
        DES_Algorithm.IP(nArray);
        DES_Algorithm.decrypt(nArray, object);
        DES_Algorithm.FP(nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        byte[] byArray2 = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24), (byte)n3, (byte)(n3 >> 8), (byte)(n3 >> 16), (byte)(n3 >> 24)};
        return byArray2;
    }

    public static boolean self_test() {
        boolean bl = false;
        try {
            byte[] byArray = new byte[8];
            byte[] byArray2 = new byte[8];
            int n = 0;
            while (n < 8) {
                byArray[n] = (byte)n;
                ++n;
            }
            n = 0;
            while (n < 8) {
                byArray2[n] = (byte)n;
                ++n;
            }
            Object object = DES_Algorithm.makeKey(byArray);
            byte[] byArray3 = DES_Algorithm.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = DES_Algorithm.blockDecrypt(byArray3, 0, object);
            bl = DES_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation in ECB mode failed");
            }
            String[][] stringArrayArray = new String[][]{{"0101010101010101", "95f8a5e5dd31d900", "8000000000000000"}, {"0101010101010101", "dd7f121ca5015619", "4000000000000000"}, {"0101010101010101", "2e8653104f3834ea", "2000000000000000"}, {"0123456789abcdef", "0123456789abcde7", "c95744256a5ed31d"}, {"0123456710325476", "89abcdef98badcfe", "f0148eff050b2716"}};
            for (n = 0; n < stringArrayArray.length; ++n) {
                object = DES_Algorithm.makeKey(DES_Algorithm.fromString(stringArrayArray[n][0]));
                byArray2 = DES_Algorithm.fromString(stringArrayArray[n][1]);
                byArray3 = DES_Algorithm.fromString(stringArrayArray[n][2]);
                byArray4 = DES_Algorithm.blockEncrypt(byArray2, 0, object);
                bl = DES_Algorithm.areEqual(byArray3, byArray4);
                if (bl) continue;
                throw new RuntimeException("ECB mode encryption #" + n + " failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static int engineBlockSize() {
        return 8;
    }

    public static final void encrypt(int[] nArray, Object object) {
        int[] nArray2 = (int[])object;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n2 << 1 | n2 >>> 31;
        n2 = n << 1 | n >>> 31;
        n = n3;
        int n4 = nArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            n3 = n2 ^ nArray2[n5++];
            int n6 = n2 ^ nArray2[n5++];
            n6 = n6 >>> 4 | n6 << 28;
            n ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
            n3 = n ^ nArray2[n5++];
            n6 = n ^ nArray2[n5++];
            n6 = n6 >>> 4 | n6 << 28;
            n2 ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
        }
        nArray[0] = n >>> 1 | n << 31;
        nArray[1] = n2 >>> 1 | n2 << 31;
    }

    public static final void encrypt(byte[] byArray, Object object) {
        int[] nArray = new int[]{byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24, byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24};
        DES_Algorithm.encrypt(nArray, object);
        int n = nArray[0];
        int n2 = nArray[1];
        byArray[0] = (byte)n;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)(n >> 16);
        byArray[3] = (byte)(n >> 24);
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)(n2 >> 16);
        byArray[7] = (byte)(n2 >> 24);
    }

    public static final void decrypt(int[] nArray, Object object) {
        int[] nArray2 = (int[])object;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n2 << 1 | n2 >>> 31;
        n2 = n << 1 | n >>> 31;
        n = n3;
        int n4 = nArray2.length;
        int n5 = n4 - 1;
        while (n5 > 0) {
            int n6 = n2 ^ nArray2[n5--];
            n3 = n2 ^ nArray2[n5--];
            n6 = n6 >>> 4 | n6 << 28;
            n ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
            n6 = n ^ nArray2[n5--];
            n3 = n ^ nArray2[n5--];
            n6 = n6 >>> 4 | n6 << 28;
            n2 ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
        }
        nArray[0] = n >>> 1 | n << 31;
        nArray[1] = n2 >>> 1 | n2 << 31;
    }

    public static final void decrypt(byte[] byArray, Object object) {
        int[] nArray = new int[]{byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24, byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24};
        DES_Algorithm.decrypt(nArray, object);
        int n = nArray[0];
        int n2 = nArray[1];
        byArray[0] = (byte)n;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)(n >> 16);
        byArray[3] = (byte)(n >> 24);
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)(n2 >> 16);
        byArray[7] = (byte)(n2 >> 24);
    }

    public static final void IP(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = (n2 >>> 4 ^ n) & 0xF0F0F0F;
        n ^= n3;
        n2 ^= n3 << 4;
        n3 = (n >>> 16 ^ n2) & 0xFFFF;
        n2 ^= n3;
        n ^= n3 << 16;
        n3 = (n2 >>> 2 ^ n) & 0x33333333;
        n ^= n3;
        n2 ^= n3 << 2;
        n3 = (n >>> 8 ^ n2) & 0xFF00FF;
        n2 ^= n3;
        n ^= n3 << 8;
        n3 = (n2 >>> 1 ^ n) & 0x55555555;
        nArray[0] = n ^ n3;
        nArray[1] = n2 ^ n3 << 1;
    }

    public static final void IP(byte[] byArray) {
        int[] nArray = new int[]{byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24, byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24};
        DES_Algorithm.IP(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        byArray[0] = (byte)n;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)(n >> 16);
        byArray[3] = (byte)(n >> 24);
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)(n2 >> 16);
        byArray[7] = (byte)(n2 >> 24);
    }

    public static final void FP(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = (n2 >>> 1 ^ n) & 0x55555555;
        n ^= n3;
        n2 ^= n3 << 1;
        n3 = (n >>> 8 ^ n2) & 0xFF00FF;
        n2 ^= n3;
        n ^= n3 << 8;
        n3 = (n2 >>> 2 ^ n) & 0x33333333;
        n ^= n3;
        n2 ^= n3 << 2;
        n3 = (n >>> 16 ^ n2) & 0xFFFF;
        n2 ^= n3;
        n ^= n3 << 16;
        n3 = (n2 >>> 4 ^ n) & 0xF0F0F0F;
        nArray[0] = n ^ n3;
        nArray[1] = n2 ^ n3 << 4;
    }

    public static final void FP(byte[] byArray) {
        int[] nArray = new int[]{byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24, byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24};
        DES_Algorithm.FP(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        byArray[0] = (byte)n;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)(n >> 16);
        byArray[3] = (byte)(n >> 24);
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)(n2 >> 16);
        byArray[7] = (byte)(n2 >> 24);
    }

    public static int[] crypt3(int n, int n2, Object object) {
        int[] nArray = (int[])object;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < 25) {
            int n7;
            int n8 = 0;
            while (n8 < n5) {
                int n9 = n4 ^ n4 >>> 16;
                int n10 = n9 & n;
                n10 ^= n10 << 16 ^ n4 ^ nArray[n8++];
                n7 = (n9 &= n2) ^ n9 << 16 ^ n4 ^ nArray[n8++];
                n7 = n7 >>> 4 | n7 << 28;
                n9 = (n3 ^= SP_TRANS[0x40 | n7 & 0x3F] | SP_TRANS[0xC0 | n7 >>> 8 & 0x3F] | SP_TRANS[0x140 | n7 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n7 >>> 24 & 0x3F] | SP_TRANS[n10 & 0x3F] | SP_TRANS[0x80 | n10 >>> 8 & 0x3F] | SP_TRANS[0x100 | n10 >>> 16 & 0x3F] | SP_TRANS[0x180 | n10 >>> 24 & 0x3F]) ^ n3 >>> 16;
                n10 = n9 & n;
                n10 ^= n10 << 16 ^ n3 ^ nArray[n8++];
                n7 = (n9 &= n2) ^ n9 << 16 ^ n3 ^ nArray[n8++];
                n7 = n7 >>> 4 | n7 << 28;
                n4 ^= SP_TRANS[0x40 | n7 & 0x3F] | SP_TRANS[0xC0 | n7 >>> 8 & 0x3F] | SP_TRANS[0x140 | n7 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n7 >>> 24 & 0x3F] | SP_TRANS[n10 & 0x3F] | SP_TRANS[0x80 | n10 >>> 8 & 0x3F] | SP_TRANS[0x100 | n10 >>> 16 & 0x3F] | SP_TRANS[0x180 | n10 >>> 24 & 0x3F];
            }
            n7 = n3;
            n3 = n4;
            n4 = n7;
            ++n6;
        }
        int[] nArray2 = new int[]{n4 >>> 1 | n4 << 31, n3 >>> 1 | n3 << 31};
        DES_Algorithm.FP(nArray2);
        return nArray2;
    }

    private static final boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final byte[] fromString(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 == 1) {
            byArray[n3++] = (byte)DES_Algorithm.fromDigit(string.charAt(n2++));
        }
        while (n2 < n) {
            byArray[n3++] = (byte)(DES_Algorithm.fromDigit(string.charAt(n2++)) << 4 | DES_Algorithm.fromDigit(string.charAt(n2++)));
        }
        return byArray;
    }

    public static final int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex digit '" + c + "'");
    }

    private static final String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    static {
        int n;
        int n2;
        err = null;
        TRACE = DEAL_Properties.isTraceable(NAME);
        SKB = new int[512];
        SP_TRANS = new int[512];
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < "D]PKESYM`UBJ\\@RXA`I[T`HC`LZQ\\PB]TL`[C`JQ@Y`HSXDUIZRAM`EK".length()) {
            int n6 = "D]PKESYM`UBJ\\@RXA`I[T`HC`LZQ\\PB]TL`[C`JQ@Y`HSXDUIZRAM`EK".charAt(n5) - 64;
            if (n6 != 32) {
                n2 = 1 << n3++;
                n = 0;
                while (n < 64) {
                    if ((n2 & n) != 0) {
                        int n7 = n4 + n;
                        SKB[n7] = SKB[n7] | 1 << n6;
                    }
                    ++n;
                }
                if (n3 == 6) {
                    n4 += 64;
                    n3 = 0;
                }
            }
            ++n5;
        }
        n4 = 0;
        int n8 = 0;
        while (n8 < 32) {
            int n9 = -1;
            n2 = 1 << n8;
            n = 0;
            while (n < 32) {
                int n10 = "g3H821:80:H03BA0@N1290BAA88::3112aIH8:8282@0@AH0:1W3A8P810@22;22A18^@9H9@129:<8@822`?:@0@8PH2H81A19:G1@03403A0B1;:0@1g192:@919AA0A109:W21492H@0051919811:215011139883942N8::3112A2:31981jM118::A101@I88:1aN0<@030128:X;811`920:;H0310D1033@W980:8A4@804A3803o1A2021B2:@1AH023GA:8:@81@@12092B:098042P@:0:A0HA9>1;289:@1804:40Ph=1:H0I0HP0408024bC9P8@I808A;@0@0PnH0::8:19J@818:@iF0398:8A9H0<13@001@11<8;@82B01P0a2989B:0AY0912889bD0A1@B1A0A0AB033O91182440A9P8@I80n@1I03@1J828212A`A8:12B1@19A9@9@8^B:0@H00<82AB030bB840821Q:8310A302102::A1::20A1;8".charAt(n4 >> 1) - 48 >> (n4 & 1) * 3 & 7;
                ++n4;
                if (n10 < 5) {
                    int n11 = n9 += n10 + 1;
                    SP_TRANS[n11] = SP_TRANS[n11] | n2;
                } else {
                    int n12 = "g3H821:80:H03BA0@N1290BAA88::3112aIH8:8282@0@AH0:1W3A8P810@22;22A18^@9H9@129:<8@822`?:@0@8PH2H81A19:G1@03403A0B1;:0@1g192:@919AA0A109:W21492H@0051919811:215011139883942N8::3112A2:31981jM118::A101@I88:1aN0<@030128:X;811`920:;H0310D1033@W980:8A4@804A3803o1A2021B2:@1AH023GA:8:@81@@12092B:098042P@:0:A0HA9>1;289:@1804:40Ph=1:H0I0HP0408024bC9P8@I808A;@0@0PnH0::8:19J@818:@iF0398:8A9H0<13@001@11<8;@82B01P0a2989B:0AY0912889bD0A1@B1A0A0AB033O91182440A9P8@I80n@1I03@1J828212A`A8:12B1@19A9@9@8^B:0@H00<82AB030bB840821Q:8310A302102::A1::20A1;8".charAt(n4 >> 1) - 48 >> (n4 & 1) * 3 & 7;
                    ++n4;
                    if (n10 == 5) {
                        int n13 = n9 += n12 + 6;
                        SP_TRANS[n13] = SP_TRANS[n13] | n2;
                    } else if (n10 == 6) {
                        int n14 = n9 += (n12 << 6) + 1;
                        SP_TRANS[n14] = SP_TRANS[n14] | n2;
                    } else {
                        n9 += n12 << 6;
                        --n;
                    }
                }
                ++n;
            }
            ++n8;
        }
    }
}

