;;; -*-Lisp-*-
;;;
;;; Towers of Hanoi

(defun hanoi (n)
  (if (zero? n)
      (format t "Huh?~%")
      (transfer 'A 'B 'C n)))

(defun print-move (from to)
  (format t "Move disk from ~s to ~s~%" from to))

(defun transfer (from to via n)
  (if (= n 1)
      (print-move from to)
      (transfer from via to (1- n))
      (print-move from to)
      (transfer via to from (1- n))))

(hanoi 3)
