This version of cfengine focusses on security and
efficiency. Several new features have been added to network
communication by cfd:

 * Encrypted transfers
 * Better authentication (by user)
 * More efficient transfers over single connection

Other things like Tripwire functionality for md5 checksums
has been added for convenience.

Upgrading
----------

Please be careful installing this version of cfengine, even if you
have been following the beta versions. There are changes in threading
policy and protocol which make remote file transfers much more
efficient and reliable with cfd. The new threading policy makes
it impossible to support the old protocol simultenously. If you rely
on cfd for all copying, then upgrading should be done with caution.
If you only have a few hosts, upgrading by hand should not be
difficult, but if you have many, you might want to think about this:
Here are some hints for a safe upgrade.

 * Copy the new cfengine files to NEWcfengine NEWcfd NEWcfrun
   and make sure that they are all copied to every host before
   running them.

 * At some time of day or night when no remote copying is taking
   place, use a process command in cfengine to kill the old
   cfd, then move the NEW files to cfengine, cfd and cfrun
   and restart cfd.

This should take care of all hosts which are alive. If any hosts
are down, they will not be upgraded and they will not be able
to speak to cfd when they come up again, unless they read
cfengine from an NFS server.

NT
--

The port to NT has been done with my two students: Bjoern Gustafson
and Joergen Kjensli.

Cfengine 1.5.0 will compile and run on Windows NT, if you
have the cygwin32 Free Software installed. Some documentation
about the port will be available soon, including tips on
the configuration of cygwin.

Cfengine can set ACLs on files, but will not work
correctly on directories yet. This will be fixed
shortly, a long with some reasonable documentation.

We have not had sufficient opportunity to test cfengine
on NT, at the College, since we do not use NT for any real
tasks, so please treat this as beta quality software and
work somewhat defensively. It should be possible for us
to test it more next year.

Regular expressions
-------------------

As of 1.5.0 cfengine requires a posix regular expression library.
In most modern systems this will work automatically, but on old legacy
systems it might cause problems compiling. If your host does not
support regcomp() and regexec(), regex.h, you should collect
the GNU regular expression library (excerpted from the C library) 

 rx-1.5.tar.gz

or later. This should cure the problem. 

On solaris machines I have experienced trouble
with header files getting mixed up. rxposix.h and regex.h.
You should probably not install the GNU library on a solaris
machine, where the regex library seems to work well.

On NT with the cygwin32 library, it was necessary to compile
GNU librx on the system. The existing regex functions compiled
but did not work.

DES Encryption
---------------

You can arrange to encrypt transferred files by symmetric
cipher, if you have the SSLeay-0.9.0 libraries installed.
The secure=true option instigates encrypted transfer.
A new program cfkey can be used to generate a key file

cfkey > /var/run/cfengine/keys
cfkey > /etc/cfengine/keys

which must then be distributed to all participating hosts.
The server can REQUIRE hosts to perform encrypted transfer
with secure=true in cfd.conf.

Known bugs
----------

 The handling of the network interface has grown increasingly
 difficult. Apart from the fact the internet sockets and ioctl
 calls are amongst the ugliest, actually disgusting, APIs I have
 ever encountered, many OSes are going over to routing sockets
 which I do not know anything about, so this will have to wait.

 If anyone who understands the new route structures for routing
 sockets would like to send me a patch to read and set routes
 netmasks and brodcast addresses, I would be for ever grateful.

Mark
