Esto es CLISP, una implementacin de Common Lisp.


 Qu es LISP ?
---------------

LISP es un lenguaje de programacin inventado por J. McCarthy en
1959. Aunque ha habido muchos dialectos de l, actualmente se ha
estandarizado y difundido ampliamente gracias al estandar industrial
COMMON LISP. Hay aplicaciones en los dominios del procesamiento del
conocimiento simblico (IA), clculo numrico (MACLISP generaba cdigo
tan bueno como el de FORTRAN), y en programas ampliamente utilizados
como editores (EMACS) y CAD (AUTOCAD). Si lo desea, puede consultar la
introduccin al lenguaje LISP:

  Sheila Hughes: Lisp. Pitman Publishing Limited, London 1986.
  107 pages.

Despus de un rato, necesitar el texto estandar que contiene la
definicin del lenguaje:

Guy L. Steele Jr.: Common Lisp - The Language. Digital Press.
  1. edition 1984, 465 pages.
  2. edition 1990, 1032 pages.

Este libro est disponible en formato HTML via FTP en:
  ftp.cs.cmu.edu:/user/ai/lang/lisp/doc/cltl/cltl_ht.tgz

y puede consultarse a travs de WWW en:

  http://www.cs.cmu.edu:8001/Web/Groups/AI/html/cltl/cltl2.html o	
  http://www.cs.cmu.edu:8001/afs/cs/project/ai-repository/ai/html/cltl/cltl2.html .

Nota para los expertos: Este texto estandar se ha convertido en un
estndar ANSI, que puede obtenerse <<<exceptionally>>> sin cargo alguno en:

  http://www.harlequin.com/books/HyperSpec/

LISP se ejecuta en un entorno interactivo. Usted introduce formas, que
sern evaluadas de inmediato. Por lo tanto, puede inspeccionar
variables, invocar funciones con unos argumentos concretos o definir
sus propias funciones.


Contenidos:
-----------

Consta de los siguientes ficheros:

      lispinit.mem       imagen de memoria necesaria para la inicializacin
      clisp.1            manual en formato `man' de Unix
      clisp.man          manual
      clisp.html         manual en format HTML
      impnotes.html      notas de la implementacin
      LISP-tutorial.txt  tutorial de LISP para aprendices
      CLOS-guide.txt     breve gua de CLOS
      editors.txt        <<<some words about text editors for Lisp>>>
      README             este texto
      SUMMARY            pequea descripcin de CLISP
      ANNOUNCE           declaracin
      NEWS               lista de modificaciones desde la ltima versin
      COPYRIGHT          derechos de autor
      GNU-GPL            licencia de software libre
      config.lsp         configuracin dependiente del lugar

y - cuando le apetezca, si le gusta leer cdigo fuente -

      *.lsp              el cdigo fuente de lispinit.mem
      *.fas              los mismos ficheros, una vez compilados


Instalacin:
------------

Cambie las cadenas en SRC/CONFIG.LSP, empleando para ello un editor de
textos.
Luego ejecute

         lisp.exe -M lispinit.mem

Cuando aparezca el inductor de comandos

      > _

teclee

        (compile-file "src/config.lsp")
        (load "src/config.fas")

y luego

        (saveinitmem)

para sobreescribir el fichero LISPINIT.MEM con su configuracin. A
continuacin

        (exit)

Luego cree un directorio, y ponga en l el ejecutable con la imagen de
memoria.
Suponiendo D:\LIB\LISP :

   mkdir d:\lib\lisp
   copy lisp.exe d:\lib\lisp
   copy lispinit.mem d:\lib\lisp

Y cree un fichero de ejecucin por lotes que ejecute lisp:

   copy con c:\bat\clisp.bat
   d:\lib\lisp\lisp.exe -M d:\lib\lisp\lispinit.mem -B d:\lib\lisp\ %1 %2 %3 %4 %5 %6 %7 %8 %9
   [Ctrl-Z]


Cuando encuentre problemas:
---------------------------

Despus de un error, se encontrar en el depurador:

     1. Break> _

En l, usted puede evaluar formas como siempre. Ms an:

     Help
               invoca la ayuda
     Abort     o
     Unwind
               retrocede hasta el bucle de entrada ms reciente
     Backtrace
               muestra los contenidos de la pila, til para la depuracin

Y puede consultar el valor de las variables de las funciones donde se
produjo el error.

enve una descripcin del error y una descripcin de cmo reproducir
el error a los autores o al "mantenedor". Por favor, acompae su mensaje
de la versin de CLISP que puede obtener invocando la funcin
(lisp-implementation-version).


Cdigo fuente:
--------------

El cdigo fuente de CLISP est disponible en
     ftp://clisp.cons.org/pub/lisp/clisp/source/clispsrc*


Lista de correo:
----------------

<<<There are three mailing lists for users of CLISP. You find subscription
information and archives on the homepage http://clisp.cons.org/.>>>


Agradecimientos:
----------------

Estamos muy agradecidos a 
  * Guy L. Steele y otros muchos por la especificacin de Common Lisp.


Autores:
--------

        Bruno Haible
        Michael Stoll

Email: clisp-list@lists.sourceforge.net

"Mantenedor":
-------------

        Marcus Daniels

Email: marcus@sysc.pdx.edu
