/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.transport;

import org.gnunet.transport.HelloAddress;
import org.gnunet.transport.PeerAddressListCallback;
import org.gnunet.transport.PeerAddressMonitorCallback;
import org.gnunet.transport.messages.AddressIterateMessage;
import org.gnunet.transport.messages.AddressIterateResponseMessage;
import org.gnunet.transport.messages.BlacklistInitMessage;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RunaboutMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressQuery {
    private static final Logger logger = LoggerFactory.getLogger(AddressQuery.class);
    private final boolean oneShot;
    private final PeerIdentity peerIdentity;
    private final PeerAddressMonitorCallback monitorCallback;
    private final PeerAddressListCallback listCallback;
    private Client client;

    public AddressQuery(Configuration configuration, PeerIdentity peerIdentity, PeerAddressMonitorCallback peerAddressCallback) {
        this.oneShot = false;
        this.peerIdentity = peerIdentity;
        this.monitorCallback = peerAddressCallback;
        this.listCallback = null;
        this.client = new Client("transport", configuration);
        this.client.send(new BlacklistInitMessage());
        this.client.installReceiver(new AddressMonitorReceiver());
        this.createAndInitClient(configuration);
    }

    public AddressQuery(Configuration configuration, PeerIdentity peerIdentity, PeerAddressListCallback listCallback) {
        this.oneShot = true;
        this.peerIdentity = peerIdentity;
        this.listCallback = listCallback;
        this.monitorCallback = null;
        this.createAndInitClient(configuration);
    }

    private void createAndInitClient(Configuration configuration) {
        this.client = new Client("transport", configuration);
        this.client.send(new BlacklistInitMessage());
        this.client.installReceiver(new AddressMonitorReceiver());
        this.sendInitMessage();
    }

    private void sendInitMessage() {
        AddressIterateMessage m = new AddressIterateMessage();
        m.oneShot = this.oneShot;
        m.peer = this.peerIdentity == null ? new PeerIdentity() : this.peerIdentity;
        m.timeout = AbsoluteTime.FOREVER.asMessage();
        this.client.send(m);
    }

    private final class AddressMonitorReceiver
    extends RunaboutMessageReceiver {
        private AddressMonitorReceiver() {
        }

        public void visit(AddressIterateResponseMessage m) {
            if (m.content == null) {
                if (AddressQuery.this.listCallback != null) {
                    AddressQuery.this.listCallback.onDone();
                } else {
                    AddressQuery.this.client.reconnect();
                    AddressQuery.this.sendInitMessage();
                }
                return;
            }
            if (AddressQuery.this.listCallback != null) {
                if (m.content.addrLen == 0 && m.content.pluginLen == 0) {
                    logger.warn("empty peer address list item");
                } else {
                    HelloAddress helloAddress = new HelloAddress();
                    helloAddress.peer = m.content.peerIdentity;
                    AddressQuery.this.listCallback.onPeerAddress(helloAddress);
                }
            } else if (m.content.addrLen == 0 && m.content.pluginLen == 0) {
                AddressQuery.this.monitorCallback.onPeerDisconnect(m.content.peerIdentity);
            } else {
                HelloAddress helloAddress = new HelloAddress();
                helloAddress.peer = m.content.peerIdentity;
                AddressQuery.this.monitorCallback.onPeerAddress(helloAddress);
            }
        }

        @Override
        public void handleError() {
            AddressQuery.this.client.reconnect();
            AddressQuery.this.client.send(new BlacklistInitMessage());
        }
    }
}

