
(setq s4p-buf "*ptr*")

(defun s4p--log-message (string)
  (save-excursion
    (set-buffer s4p-buf)
    (goto-char (point-max))
    (insert string "\n")))

(defun s4p--find-ptrs-in-current-buffer ()
  (interactive)
  (assert (eq major-mode 'c++-mode))
  (goto-char (point-min))
  (while (setq p (re-search-forward "(" nil t))
    (forward-char -1)
    (setq p-min (point))
    (forward-sexp 1)
    (setq p-max (point))
    ;;(setq bs (buffer-substring-no-properties p-min p-max))
    ;;(ptr--log-message bs)
    (goto-char p-min)
    (while (re-search-forward "[(,][ \t]*\\(ptr<[a-zA-Z0-9]*\\)" p-max t)
      (s4p--log-message (format "%s:%d: found: %s"
                                (buffer-file-name)
                                (d-what-line)
                                (buffer-substring-no-properties (match-beginning 1) (match-end 1)))))
    (goto-char p)))

(defun s4p--find-ptrs-in-file-list (list)
  (save-excursion
    (if (get-buffer s4p-buf)
        (kill-buffer s4p-buf))
    (generate-new-buffer s4p-buf)
    (setq ptr list)
    (while (car ptr)
      (find-file (car ptr))
      (s4p--find-ptrs-in-current-buffer)
      (kill-buffer nil)
      (setq ptr (cdr ptr))))
  (switch-to-buffer s4p-buf)
  (goto-char (point-min))
  (insert "\n\n") ;;; NOTE: needed for enter key to work
  (compilation-mode)
  (read-only-mode -1)
  )


;;; (setq file-list (directory-files-no-dotdotdot "~/3-autogc-nosplit/2007/r4" t "\\.\\(cc\\|ch\\|hh\\)$"))
;;; (setq file-list '("~/3-autogc-nosplit/2007/r4/a.cc"))
;;; (s4p--find-ptrs-in-file-list file-list)

;;foo(ptr<Avcc> foo,ptr<Deg> hello)
;;(what-line)
