/* Copyright (C) 1995, 1997, 1998, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ulrich Drepper <drepper@gnu.ai.mit.edu>, August 1995.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <errno.h>
#include <sys/msg.h>
#include <ipc_priv.h>

#include <sysdep.h>
#include <string.h>
#include <sys/syscall.h>
#include <bp-checks.h>

#include "kernel-features.h"

struct __old_msqid_ds
{
  struct __old_ipc_perm msg_perm;	/* structure describing operation permission */
  struct msg *__unbounded __msg_first;	/* pointer to first message on queue */
  struct msg *__unbounded __msg_last;	/* pointer to last message on queue */
  __time_t msg_stime;			/* time of last msgsnd command */
  __time_t msg_rtime;			/* time of last msgrcv command */
  __time_t msg_ctime;			/* time of last change */
  struct wait_queue *__unbounded __wwait; /* ??? */
  struct wait_queue *__unbounded __rwait; /* ??? */
  unsigned short int __msg_cbytes;	/* current number of bytes on queue */
  unsigned short int msg_qnum;		/* number of messages currently on queue */
  unsigned short int msg_qbytes;	/* max number of bytes allowed on queue */
  __ipc_pid_t msg_lspid;		/* pid of last msgsnd() */
  __ipc_pid_t msg_lrpid;		/* pid of last msgrcv() */
};

extern int __syscall_msgctl (int, int, void *);

/* Allows to control internal state and destruction of message queue
   objects.  */
int __new_msgctl (int, int, struct msqid_ds *);

int
__new_msgctl (int msqid, int cmd, struct msqid_ds *buf)
{
  /* This is a misnomer -- Alpha had 32-bit uids at the beginning
     of time.  However, msg_qnum and msg_qbytes changed size at
     the same time the size of uid changed elsewhere.  */
#if __ASSUME_32BITUIDS > 0
  return INLINE_SYSCALL (msgctl, 3, msqid, cmd | __IPC_64, CHECK_1 (buf));
#else
  switch (cmd) {
    case MSG_STAT:
    case IPC_STAT:
    case IPC_SET:
      break;
    default:
      return INLINE_SYSCALL (msgctl, 3, msqid, cmd, CHECK_1 (buf));
  }

  {
    int save_errno = errno, result;
    struct __old_msqid_ds old;

    /* Unfortunately there is no way how to find out for sure whether
       we should use old or new msgctl.  */
    result = INLINE_SYSCALL (msgctl, 3, msqid, cmd | __IPC_64, CHECK_1 (buf));
    if (result != -1 || errno != EINVAL)
      return result;

    __set_errno(save_errno);
    if (cmd == IPC_SET)
      {
	old.msg_perm.uid = buf->msg_perm.uid;
	old.msg_perm.gid = buf->msg_perm.gid;
	old.msg_perm.mode = buf->msg_perm.mode;
	old.msg_qbytes = buf->msg_qbytes;
	if (old.msg_perm.uid != buf->msg_perm.uid ||
	    old.msg_perm.gid != buf->msg_perm.gid ||
	    old.msg_qbytes != buf->msg_qbytes)
	  {
	    __set_errno (EINVAL);
	    return -1;
	  }
      }
    result = INLINE_SYSCALL (msgctl, 3, msqid, cmd, __ptrvalue (&old));
    if (result != -1 && cmd != IPC_SET)
      {
	memset(buf, 0, sizeof(*buf));
	buf->msg_perm.__key = old.msg_perm.__key;
	buf->msg_perm.uid = old.msg_perm.uid;
	buf->msg_perm.gid = old.msg_perm.gid;
	buf->msg_perm.cuid = old.msg_perm.cuid;
	buf->msg_perm.cgid = old.msg_perm.cgid;
	buf->msg_perm.mode = old.msg_perm.mode;
	buf->msg_perm.__seq = old.msg_perm.__seq;
	buf->msg_stime = old.msg_stime;
	buf->msg_rtime = old.msg_rtime;
	buf->msg_ctime = old.msg_ctime;
	buf->__msg_cbytes = old.__msg_cbytes;
	buf->msg_qnum = old.msg_qnum;
	buf->msg_qbytes = old.msg_qbytes;
	buf->msg_lspid = old.msg_lspid;
	buf->msg_lrpid = old.msg_lrpid;
      }
    return result;
  }
#endif
}

#include <shlib-compat.h>
versioned_symbol (libc, __new_msgctl, msgctl, GLIBC_2_2);
