//
// mexptest.cxx
//
// test modular exponentiation
// should envoked the Montgomery method
// test data from FIPS186
//
// Copyright (C) 1997 by Leonard Janke (janke@unixg.ubc.ca) 

#include <iostream.h>
#include <iomanip.h>
#include <linteger/lmath.hxx>

void main(int, char**)
{
  LInteger g("0xb3085510021f999049a9e7cd3872ce9958186b5007e7adaf25248b58a3dc4f71781d21f2df89b71747bd54b323bbecc443ec1d3e020dadabbf7822578255c104");
  LInteger p("0xd411a4a0e393f6aab0f08b14d18458665b3e4dbdce2544543fe365cf71c8622412db6e7dd02bbe13d88c58d7263e90236af17ac8a9fe5f249cc81f427fc543f7");
  LInteger y("0xb32fbec03175791df08c3f861c81df7de7e0cba7f1c4f7269bb12d6c628784fb742e66ed315754dfe38b5984e94d372537f655cb3ea4767c878cbd2d783ee662");
  LInteger u1("0x347089a29897273bfc7a774fa70e0e0e153bcc95");
  LInteger u2("0x793d9312a41b88afaa2c1bd949ec3bee2e75d2f5");
  const LInteger exp1("0x57A198AB2C8EA0B64810767AFF732FB2DA5FCAFB278889F196B60B9C1285B8481D08505E201A5C68523A15EE2FB62A56D141DC4D71925EF06ACDE0A5B89C5671");
  const LInteger exp2("0x5D983D20BE604E23FB19BEC87860490A41B865DC0F5623F40724A795021BCD8C93A39DDF51CAE380FB6D682A676608F765227FF05E44CCF49767E4A60832D33F");

  LInteger res1=LMath::ModExp(g,u1,p);
  LInteger res2=LMath::ModExp(y,u2,p);
 
  cout <<"Test1"<<endl;
  cout <<"g=          "<<g<<endl;
  cout <<"u1=         "<<u1<<endl;
  cout <<"p=          "<<p<<endl;
  cout <<"g^u1 mod p= "<<res1<<endl;
  
  if ( res1==exp1 )
    cout <<"*****Passed!*****"<<endl;
  else
    cout <<"*****Failed!*****"<<endl;
  
  cout <<endl;

  cout <<"Test2"<<endl;
  cout <<"y=          "<<y<<endl;
  cout <<"u2=         "<<u2<<endl;
  cout <<"p=          "<<p<<endl;
  cout <<"y^u2 mod p= "<<res2<<endl;

  if ( res2==exp2 )
    cout <<"*****Passed!*****"<<endl;
  else
    cout <<"*****Failed!*****"<<endl;
}
