/*
  sshfilecopyi.h

  Author: Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 2000 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Definitions common to the sshfilecopy*.* and sshfc_*.* files.
 */

#ifndef SSHFILECOPYI_H
#define SSHFILECOPYI_H

#include "sshfc_conn.h"
#include "sshdsprintf.h"
#include "sshfsm.h"
#include "sshtimeouts.h"

#define SSH_FC_MAX_BUFFER_SIZE 0x40000
#define SSH_FC_READ_MAX 0x8000
#define SSH_FC_CONNECTION_WAIT_TIMEOUT 1L,0L

#ifdef __SUNPRO_C
#pragma error_messages (off,E_STATEMENT_NOT_REACHED)
#endif /* __SUNPRO_C */

/* Macro for checking the validity of the connection, and if the
   connection is not ok, jump to a specified error state.

   The ``CURRENT_STATE_HOLDER'' has to defined. (and
   it has to be able to hold a char pointer)
*/
#define SSH_FC_CHECK_CONN(conn_flags, conn_error_state)         \
do                                                              \
{                                                               \
  if ((conn_flags) != SSH_FCC_OK)                               \
    {                                                           \
      (CURRENT_STATE_HOLDER) =                                  \
          (char *)ssh_fsm_get_thread_current_state(thread);     \
      SSH_FSM_SET_NEXT((conn_error_state));                     \
      return SSH_FSM_CONTINUE;                                  \
    }                                                           \
} while(0);                                                     \

/* Record for filenames and attributes, needed in the transfer. */
struct SshFileCopyFileRec
{
  SshFileAttributes attributes;
  SshFileHandle handle;
  char *name;
  char *long_name;
  /* If non-NULL, this file is a directory. Contains the files in this
     directory. */
  SshFileCopyLocation dir_entries;
};

/* List item for source files or destination file. */
struct SshFileCopyLocationRec
{
  /* File-attributes for the directory, from where the copying starts
     (in case of source files) or the destination file/directory. If
     parent_dir is not NULL, points to the file (dir) whose contents
     this SshFileCopyLocation describes. */
  SshFileCopyFile file;
  /* List of source files. This is NULL if this SshFileCopyLocation is
     used as destination. Items in this list are of type SshFileCopyFile. */
  SshDlList file_list;
  /* FALSE if destination, TRUE if source. */
  Boolean source;
  /* Boolean value, which is FALSE if the files in the list have
     actually been tested for existence.*/
  Boolean raw;
  /* Parent dir of location. NULL if root dir. */
  SshFileCopyLocation parent_dir;
};

struct SshFileCopyFileListItemRec
{
  char *original_filename;
  SshFileCopyLocation files;
};


/* Helper callback which is called when registered timeout expires. */
void connection_wait_timeout(void *context);

/* mapcar function which rewinds SshFileCopyLocations in a list. */
void *location_list_rewind(void *item, void *ctx);

#endif /* SSHFILECOPYI_H */
