/*

  sshfsmstreams_states.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Sep  2 14:52:54 1999.

*/

/* Include this into a state array. */

#ifdef SSH_FSM_PROTOTYPES
#define SSH_FSM_DECL(x,y,z) SSH_FSM_STEP(z);
#else
#define SSH_FSM_DECL SSH_FSM_STATE
#endif /* SSH_FSM_PROTOTYPES */

SSH_FSM_DECL("util/streamstub/abort-reader", "finish the reading thread",
              ssh_streamstub_abort_reader)

SSH_FSM_DECL("util/streamstub/abort-writer", "finish the writing thread",
              ssh_streamstub_abort_writer)

SSH_FSM_DECL("util/streamstub/send-eof", "delegate sending EOF",
              ssh_streamstub_send_eof)

SSH_FSM_DECL("util/streamstub/finish", "finish the stream stub (draining)",
              ssh_streamstub_finish)

SSH_FSM_DECL("util/streamstub/abort", "abort the stream stub immediately",
              ssh_streamstub_abort)

SSH_FSM_DECL("util/streamstub/die", "terminating the parent thread",
              ssh_streamstub_die)

SSH_FSM_DECL("util/streamstub/parent", "initializing parent thread",
              ssh_streamstub_parent)

SSH_FSM_DECL("util/streamstub/read", "read data from stream",
              ssh_streamstub_read)

SSH_FSM_DECL("util/streamstub/write", "write data to stream",
              ssh_streamstub_write)

#undef SSH_FSM_DECL
#undef SSH_FSM_PROTOTYPES
