/*
 * snk_ftp - support routines for ftpd
 *
 * Part of the SNK extension to logdaemon
 *
 * Written by William LeFebvre, Argonne National Laboratory
 */

#include <stdio.h>
#include <pwd.h>

#include "snk.h"

/* char *snk_ftpprompt(char *name, struct passwd *pw, int pwok)
 *	Return a string suitable for use in an FTP prompt string.
 */

char *snk_ftpprompt(name, pw, pwok)

char *name;
struct passwd *pw;
int pwok;

{
    static char buf[128];
    struct scent sc;

    /* do first-stage lookup to see if this user has a SNK card assigned */
    if (getscent(&sc, pw->pw_name) == 0)
    {
	/* compose an appropriate SNK challenge prompt */
	sprintf(buf, "SNK Challenge \"%s\"%s", 
		snk_challenge(),
		pwok ? "" : " (SNK response required).");
    }
    else
    {
	sprintf(buf, "%s required for %s.",
		pwok ? "Password" : "SNK response",
		name);
    }

    return(buf);
}
