#include <krb.h>

 /*
  * Do an equivalent to kinit here. We need to do the kinit before trying to
  * cd to the home directory, because it might be on a remote filesystem that
  * uses Kerberos authentication. We also need to do this after we've
  * setuid() to the user, or krb_get_pw_in_tkt() won't know where to put the
  * ticket.
  * 
  * We don't really care about whether or not it succeeds; if it fails, we'll
  * just carry on bravely.
  * 
  * NB: we assume: local realm, same username and password as supplied to login.
  * 
  * Security note: if pp is NULL, login doesn't have the password. This is
  * common when it's called by rlogind. Since this is almost always a remote
  * connection, we don't want to risk asking for the password by supplying a
  * NULL pp to krb_get_pw_in_tkt(), because somebody could be listening. So
  * we'll just forget the whole thing.  -jdd
  */

login_kerberos(username, password)
char   *username;
char   *password;
{
    char    realm[REALM_SZ];

    (void) krb_get_lrealm(realm, 1);
    if (password != 0)
	(void) krb_get_pw_in_tkt(username, "", realm, "krbtgt",
				 realm, DEFAULT_TKT_LIFE, password);
}
