/* $Id: ipsec_access.h,v 1.1 1997/12/02 19:25:30 gordo Exp $ */
/*
 * Simple ipsec interface for use as a library.
 *
 * Copyright (C) 1997, Gordon Oliver
 *
 * No warranty whatsoever is offered for this software.
 *
 * Permission to use, modify, or do whatever you wish with
 * this software is hereby granted, so long as you do not
 * remove this copyright notice, and so long as you do not
 * hold me responsible for any damage that it might cause.
 * You must also add a notice that you changed this software.
 *
 * This is _not_ the GNU GPL. You can sell this if you so choose.
 * You do _not_ have to include source for this work or
 * derived works.
 *
 * I would appreciate credit in which you use this software or
 * the linux PF_KEY interface.
 */

#ifndef __IPSEC_ACCESS_H__
#define __IPSEC_ACCESS_H__

extern int ipsec_dump(int s, int type);
extern int ipsec_register(int s, int type);
extern int ipsec_flush(int s, int type);
extern int ipsec_acquire(int s, int type,
			 struct sockaddr *sa,
			 struct sockaddr *da,
			 struct sockaddr *pa);
extern int ipsec_getspi(int s, int type,
			struct sockaddr *sa,
			struct sockaddr *da,
			struct sockaddr *pa);
extern int ipsec_update_ah(int s, __u32 spi, int algo,
			struct sockaddr *sa,
			struct sockaddr *da,
			struct sockaddr *pa,
			char *kmat, int ksize);
extern int ipsec_update_esp(int s, __u32 spi, int algo,
			    struct sockaddr *sa,
			    struct sockaddr *da,
			    struct sockaddr *pa,
			    char *esp_kmat, int esp_ksize,
			    char *ah_kmat, int ah_ksize);
extern int ipsec_delete(int s, int type, __u32 spi,
			struct sockaddr *sa,
			struct sockaddr *da,
			struct sockaddr *pa);
extern int ipsec_get(int s, int type, __u32 spi,
			struct sockaddr *sa,
			struct sockaddr *da,
			struct sockaddr *pa);

#endif /* __IPSEC_ACCESS_H__ */

/* EOF $Id: ipsec_access.h,v 1.1 1997/12/02 19:25:30 gordo Exp $ */
