/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "constants.h"
#include "defs.h"
#include "sha1.h"

/*
 * This file contains cookie generation/verification routines.
 */

/* 
 * Generate a cookie, first 
 * argument is true if we're to create an
 * Initiator cookie. Length SHOULD be a multiple of sizeof(u_int32_t). 
 */
void
get_cookie(int initiator, u_char *cookie, int length, struct sockaddr sa)
{
    u_char buffer[SECRET_VALUE_LENGTH];
    SHA1_CTX ctx;
    int i;
    
    if (initiator == ISAKMP_INITIATOR)
      get_rnd_bytes(cookie, length);
    else  /* Responder cookie */
    {
	/* This looks as good as any way */
	SHA1Init(&ctx);
	SHA1Update(&ctx, (u_char *)&sa, sizeof(sa));
	SHA1Update(&ctx, secret_of_the_day, SECRET_VALUE_LENGTH);
	SHA1Update(&ctx, (u_char *)&sa, sizeof(sa));
	SHA1Final(buffer, &ctx);
	bcopy(buffer, cookie, length);
    }
}

/* 
 * Verify a (responder) cookie.
 */
int
verify_cookie(u_char *cookie, int length, struct sockaddr sa)
{
    u_char buffer[SECRET_VALUE_LENGTH];
    SHA1_CTX ctx;

    SHA1Init(&ctx);
    SHA1Update(&ctx, (u_char *)&sa, sizeof(sa));
    SHA1Update(&ctx, secret_of_the_day, SECRET_VALUE_LENGTH);
    SHA1Update(&ctx, (u_char *)&sa, sizeof(sa));
    SHA1Final(buffer, &ctx);

    return (!bcmp(cookie, buffer, length));
}
