# extract-files.awk
#
#/*****************************************************************************
#                Copyright Carnegie Mellon University 1992
#
#                      All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of CMU not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
# CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
# SOFTWARE.
#*****************************************************************************/
#
#
# Awk script to break the input into multiple files.
#
# $Header: extract-files.awk,v 1.1 91/01/04 18:01:50 heydon Exp $
#
# Written by Allan Heydon for the Miro project at Carnegie Mellon
#
# DESCRIPTION
#   The input is assumed to contain file redirection lines of the form:
#     > filename
#   All output following this directive, up until the next such directive, is
#   redirected to the named file. The file is created if it did not exist; if
#   it did exist, it is erased before writing to it begins. Before the
#   appearence of the first redirection line, output is sent to /dev/null.

BEGIN {
    outfile = "/dev/null";
    openfile = 0;
}

{
    if ($1 == ">") {
	if (openfile) {
	    close(outfile);
	    print count " lines extracted."
        }
	openfile = 1;
	count = 0;
	outfile = $2;
	printf "Extracting to file %s...", $2;
    } else {
	print $0 > outfile;
	count++;
    }
}

END {
    close(outfile);
    print count " lines extracted."
}
