# iff2arrows.awk
#
#/*****************************************************************************
#                Copyright Carnegie Mellon University 1992
#
#                      All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of CMU not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
# CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
# SOFTWARE.
#*****************************************************************************/
#
#
# Bawk(1) script to pretty-print arrow information in an IFF file.
#
# $Header: iff2arrows.awk,v 1.3 91/10/24 17:01:25 heydon Exp $
#
# Written by Allan Heydon for the Miro project at Carnegie Mellon
#
# INPUT FORMAT
#   This script assumes the input IFF file is in a somewhat restricted
#   format. First, all >BOX declarations must occur in the input *before* any
#   >ARROW entries they might be used in. Second, all >BOX and >ARROW entries
#   must occupy exactly 1 line each.
#
# SEE ALSO
#   ~miro/bin/iff2arrows	script using this awk program
#
# OPERATION NOTE
#   This script contains commands that awk(1) does not understand. Use
#   bawk(1) to process it instead (bawk implements the full language).

# BEGIN =======================================================================

# set field separator so " ", "=", and ";" all separate fields
BEGIN {
  # set field separator so "=", ";" separate fields
  FS = "[ \t]*[;=][ \t]*"

  # define separator character for lists
  PERM_SEP_CHAR = "[ \t]*,[ \t]*"
}

# BOX =========================================================================

# remember name of each box in box[] (indexed by sysname)
/^[ \t]*>[ \t]*BOX/ {
  match($1,"^[ \t]*>[ \t]*BOX[ \t]*");
  $1 = substr($1,RLENGTH+1);
  for (i=1; i < NF; i = i+2) {
    if ($i == "sysname") sysnamei = i+1;
    else if ($i == "name") namei = i+1;
  }
  box[$sysnamei] = $namei
  next;
}

# ARROW =======================================================================

/^[ \t]*>[ \t]*ARROW/ {
  match($1,"^[ \t]*>[ \t]*ARROW[ \t]*");
  $1 = substr($1,RLENGTH+1);
  for (i=1; i < NF; i = i+2) {
    if      ($i == "from")        { from = $(i+1);    }
    else if ($i == "to")          { to = $(i+1);      }
    else if ($i == "parity")      { parity = $(i+1);  }
    else if ($i == "permissions") { permset = $(i+1); }
  }
  if (!(from in box)) {
    print "Unknown box sysname: " from;
    exit;
  } else if (!(to in box)) {
    print "Unknown box sysname: " to;
    exit;
  }
  xchar = (parity == "pos") ? "-" : "X";
  if (substr(permset,1,1) == "{" && substr(permset,length(permset)) == "}") {
    permset = substr(permset,2,length(permset)-2);
    perm_cnt = split(permset,perms,PERM_SEP_CHAR);
    for (i=1; i<=perm_cnt; i++) {
      printf("%8s %25s -%s-> %-25s\n",perms[i],box[from],xchar,box[to]);
    }
  } else {
    print "Permissions string '" permset "' of improper form.";
    exit(1);
  }
}
