# ls-lgR.awk
#
#/*****************************************************************************
#                Copyright Carnegie Mellon University 1992
#
#                      All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of CMU not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
# CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
# SOFTWARE.
#*****************************************************************************/
#
#
# Awk(1) script to process output from "ls -lgR"
#
# $Header: ls-lgR.awk,v 1.1 91/01/04 18:02:50 heydon Exp $
#
# Written by Allan Heydon for the Miro project at Carnegie Mellon
#
# DESCRIPTION
#   1) Strips blanklines, "total" lines, and lines corresponding to entries
#      for the "." and ".." directories.
#   2) Handles "Permission denied" lines by printing ?'s for the protection,
#      owner, and group-owner fields.
#   3) Remembers the name of the directory printed in "dirname:" lines and
#      prepends this name to the names of entries in the directory.
#
# SEE ALSO
#  ~miro/bin/searchfs	uses this awk script to search a filesystem subtree

# ignore blank lines or those starting with "total"
(NF == 0 || $1 == "total") {
  next;
}

# remember lines of the form "path:"
(NF == 1 && $1 ~ /:$/) {
  curr_dir = substr($1,1,length($1)-1) "/";
  next;
}

# catch "Permission denied" lines
/not found: Permission denied/ {
  printf("?????????? %-8s %-8s %s\n","?","?",$1);
  next;
}
/unreadable: Permission denied/ {
  printf("?????????? %-8s %-8s %s/*\n","?","?",$1);
  next;
}

# Skip lines for directories "." or ".."
($9 == "./" || $9 == "../") {
  next;
}

# Default action
{ printf("%s %-8s %-8s %s%s\n",$1,$3,$4,curr_dir,$9); }
