/* AMBIG.H

   Type and function declarations for the ambig.c module.

   $Header: ambig.h,v 1.4 91/10/29 14:46:00 heydon Exp $

   Written for the Miro project at Carnegie Mellon by Allan Heydon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef AMBIG_H
#define AMBIG_H

#include <stdio.h>

#include "elts.h"

/* Exit Codes */
#define OKAY_EXIT    (0)	/* no error */
#define COMMAND_EXIT (1)	/* error on command-line */
#define ERROR_EXIT   (2)	/* syntax or parsing error */
#define AMBIG_EXIT   (3)	/* ambiguity detected */

/* TYPES ================================================================== */

typedef struct {		/* command-line options */
    FILE *fp;			/* output stream */
    Boolean matrix;		/* True = generate compact access matrix */
    Boolean full_matrix;	/* True = generate full access matrix */
    Boolean lisp_output;	/* False = human output; True = lisp */
    Boolean atom_output;	/* True = generate rels for atom pairs only */
    PermList *perm_list;	/* list of permissions to consider */
} Options;

/* FUNCTION DECLARATIONS =================================================== */

Options *NewOptions( /* void */ );
/* Create and return a new Options structure.
*/

int CheckAmbig( /* Options *options, Pict *pict */ );
/* Checks the picture 'pict' for ambiguities for the permissions named by
   'options->perm_list', or for *all* permissions if 'options->perm_list' ==
   NULL. The output is sent to 'options->fp', written in a lisp-like format if
   'options->lisp_output' is true. By default, only ambiguous relations are
   described; if 'options->matrix' is True, then a compact representation of
   the access matrix in a Lisp format is written. If 'options->full_matrix'
   is True, then the complete access matrix is written.

   Returns the number of ambiguities found.
*/

#endif AMBIG_H
