/* PICT.C

   Module for creating and storing instance picture structures.

   $Header: pict.c,v 1.1 91/08/01 20:07:07 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <my-types.h>
#include "mem.h"
#include <my-defs.h>

#include "box-type.h"
#include "sysname-types.h"
#include "elts.h"
#include "id-table.h"
#include "pict.h"

/* GLOBAL FUNCTIONS ======================================================== */

Pict *NewPict()
{
    Pict *result;
    result = AllocOne(Pict);
    result->s[0].cnt = result->s[1].cnt = 0;
    result->s[0].levels = result->s[1].levels = 0;
    result->s[0].u.boxes = result->s[1].u.boxes = (Box *)NULL;
    result->perms = 1;
    result->perm_cnt = 0;
    result->perm_list = (PermList *)NULL;
    result->perm_entries = (TableEntry **)NULL;
    result->box_types = (BoxTypeList *)NULL;
    result->table = NewIdHashTable();
    result->b_sysnames = NewBSysnameTable();
    result->a_sysnames = NewASysnameTable();
    return(result);
}

void BuildPermissionArray(pict)
  Pict *pict;
{
    PermList *curr;
    TableEntry *tbl;

    pict->perm_entries = AllocPtrArray(TableEntry,pict->perm_cnt);
    StepLinkedList(curr,pict->perm_list) {
	tbl = FindTableId(pict->table,PermNameId,curr->perm_name);
	Assert(tbl != NULL);
	Assert(0 <= tbl->u.perm_val->index);
	Assert(tbl->u.perm_val->index < pict->perm_cnt);
	pict->perm_entries[tbl->u.perm_val->index] = tbl;
    }
}
