/* RELS.G

   Global variables for the rels.c module.

   $Header: rels.g,v 1.2 91/09/17 23:54:18 heydon Exp $

   Written for the Miro project at Carnegie Mellon by Allan Heydon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef AMBIG_G
#define AMBIG_G

#include <stdio.h>
#include <my-types.h>

#include "rels.h"

/* GLOBAL VARIABLES ======================================================= */

extern FILE *OutFile;		   /* output stream */
extern Boolean PrintCompactMatrix; /* print compact access matrix ? */
extern Boolean PrintFullMatrix;	   /* print full access matrix? */
extern Boolean PrintLisp;	   /* should output be in lisp format? */
extern int AmbigEntryCnt;	   /* number of ambiguous entries found */
extern WSetTable WSetTbl;	   /* hash table for WSet's */
extern WSet *DefaultSet;	   /* WSet of single default (neg) arrow */
extern String PermName;		   /* name of current permission */

#ifdef MEASURE
/* ComputeWBlock() variables */
extern int WBlkInheritedCnt;	/* # of times single WSet inherited */
extern int WBlkComputedCnt;	/* # of times single WSet computed */

/* ComputeWSet() variables */
extern int WSetFromArrowCnt;	/* # of times WSet computed from arrow */
extern int WSetInheritedCnt;	/* # of times single WSet inherited */
extern int WSetComputedCnt;	/* # of times single WSet computed */

/* FastMinWSet() variables */
extern int EqSets;		/* # times FastMinWSet finds equal sets */
extern int FirstSetDef;		/* # times FastMinWSet finds first==Default */
extern int SecondSetDef;	/* # times FastMinWSet finds second==Default */
extern int MinWSetCnt;		/* # times FastMinWSet invokes MinWSet() */

/* FindOrAddWSet() variables */
extern int WSetHitCnt;		/* # of hits on the WSetTable */
extern int WSetMissCnt;		/* # of misses on the WSetTable */

/* ArrowOverrides() variables */
extern int EqlArrowCnt;		/* # of comparisons resolved due to = arrows */
extern int WrongLevelCnt;	/* # of comparisons resolved by levels */
extern int ArrowPairHitCnt;	/* # of hits on ArrowPairTable */
extern int ArrowCompareCnt;	/* # of actual arrow comparisons */

/* AncestorBox() variables */
extern int AncestorBoxCallCnt;	/* # of times AncestorBox() called */
extern int EqlBoxesCnt;		/* # of times equal boxes to AncestorBox() */
extern int UneqlLevelsCnt;	/* # of times levels det'd AncestorBox() */
#endif MEASURE

#endif AMBIG_G
