/* SYSNAME-TYPES.H

   Header file defining Box and Arrow sysname types. This file is necessary to
   avoid a cycle of dependencies in header files.

   $Header: sysname-types.h,v 1.1 91/08/01 20:09:50 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef SYSNAME_TYPES_H
#define SYSNAME_TYPES_H

#include <my-types.h>

/* MACRO DEFINITIONS ======================================================= */

/* number of different parity values (Pos & Neg) */
#define PARITY_CNT 2

/* TYPE DEFINITIONS ======================================================== */

typedef USint BSysname;		/* box sysname's */
typedef Uint  ASysname;		/* arrow sysname's */

#endif SYSNAME_TYPES_H
