/* TOP.H

   Header file for top-level ambig(1) file top.c.

   $Header: top.h,v 1.2 91/09/17 23:54:23 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef TOP_H
#define TOP_H

/* Command-line syntax:

   ambig [-m|-M] [-l] [-a] [-p perm] [-t type-file] [-o out-file] [iff-file]

     -m               generate compact access matrix (in lisp form only -- the
                        -l option is not necessary with this one)
     -M               generate full access matrix
     -l               produce output in lisp-like format
     -a               print relations for pairs of atomic boxes only; default
                        is to print for pairs depending on domain and range
			sets for each permission
     -p perm...       only check the named permissions
     -t type-file     name of file containing box-type info (default below)
     -o out-file      name of output file (default stdout)
     iff-file         instance picture to read (default stdin)

   Note: if 'type-file' is relative, and cannot be found in the current
   directory, then the TYPE_FILE_DIR directory given below is also searched.
*/

#define SYNTAX_STRING\
"SYNTAX: %s [-m|-M] [-l] [-a] [-p perm] [-t type-file] [-o out-file] [iff]\n"

/* Default directory and filename for 'type-file' */
#define BOXTYPE_FILE_DIR  "/usr/miro/libi/iff/"
#define BOXTYPE_FILE_NAME "unix-types.iff"

#endif TOP_H
