/* BOX-TYPE.C

   Module for creating BoxType objects.

   $Header: box-type.c,v 1.3 91/11/12 16:25:12 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <my-types.h>
#include "mem.h"
#include <my-defs.h>

#include "error.h"

#include "attr.h"
#include "box-type.h"
#include "id-table.h"
#include "objs.h"

/* LOCAL DEBUGGING FUNCTIONS =============================================== */

#ifdef OLD_DEBUG

static void DisplayTypeTree(tl)
  BoxTypeList *tl;
{
    fprintf(stderr,"\nBox Type Tree:\n");
    StepInitializedLinkedList(tl) {
	fprintf(stderr,"  Parent('%s') = '%s'\n",tl->bt->name,
		(tl->bt->u.parent ? tl->bt->u.parent->name : "NONE"));
    }
}

#endif OLD_DEBUG

/* LOCAL FUNCTIONS ========================================================= */

static void SetKindOfSubtree(bt,class)
  BoxType *bt;
  BoxTypeClass class;
/* Set the 'class' field of all BoxType's in the subtree rooted at 'bt' to
   'class'.
*/
{
    BoxTypeList *bl;
    bt->class = class;
    StepLinkedList(bl,bt->children) {
	SetKindOfSubtree(bl->bt,class);
    }
}

/* GLOBAL FUNCTIONS ======================================================== */

BoxType *NewBoxType(line_no)
  int line_no;
{
    BoxType *result = AllocOne(BoxType);
    result->class = Entity;
    result->attr_head = (AttrList *)NULL;
    result->attr_head_all = (AttrList *)NULL;
    result->line_no = line_no;
    result->u.supertype = (String)NULL;
    result->children = (BoxTypeList *)NULL;
    result->sum_rank = result->rank = -1.0;
    return(result);
}

Boolean BuildTypeTree(pict)
  Pict *pict;
{
    BoxType *bt;
    BoxTypeList *curr,*last,*child_entry;
    TableEntry *entry;
    Boolean error_flag = False;

    /* reverse the list pict->box_types so error messages are generated in
       order of increasing line number */
    curr = pict->box_types;
    pict->box_types = (BoxTypeList *)NULL;
    while (curr != (BoxTypeList *)NULL) {
	last = curr;
	curr = curr->next;
	last->next = pict->box_types;
	pict->box_types = last;
    }

    /* make each type point to its supertype */
    StepLinkedList(curr,pict->box_types) {
	bt = curr->bt;
	if (bt->u.supertype != (String)NULL) {
	    /* set bt->u.parent and children fields */
	    if ((entry=FindTableId(pict->table,BoxTypeId,bt->u.supertype))
		== (TableEntry *)NULL) {
		ParseErrorS(bt->line_no,"supertype '%s' does not exist",
			    bt->u.supertype);
		error_flag = True;
	    } else {
		AttrList *attr;
		AttrList **new_attr;
		/*
		 * deallocate "supertype" string */
		Dealloc(bt->u.supertype);
		/*
		 * point to parent (found in table 'entry' above) */
		bt->u.parent = entry->u.box_type;
		/*
		 * give parent a child entry back to this type */
		child_entry = AllocOne(BoxTypeList);
		child_entry->bt = bt;
		SpliceIntoList(entry->u.box_type->children,child_entry);
		/*
		 * make end of attribute list point to parent's list */
		new_attr = &(bt->attr_head_all);
		StepLinkedList(attr,bt->attr_head) {
		    *new_attr = AllocOne(AttrList);
		    (*new_attr)->attr = attr->attr;
		    new_attr = &((*new_attr)->next);
		}
		*new_attr = bt->u.parent->attr_head_all;
	    }
	}
    }

    /* set the 'kind' field of each type */
    bt = FindTableId(pict->table,BoxTypeId,SUBJ_NAME)->u.box_type;
    SetKindOfSubtree(bt,Subject);
    bt = FindTableId(pict->table,BoxTypeId,OBJ_NAME)->u.box_type;
    SetKindOfSubtree(bt,Object);
#ifdef OLD_DEBUG
    DisplayTypeTree(pict->box_types);
#endif OLD_DEBUG
    return(error_flag);
}
