/* EXTRACT-OBJS.H

   Type definitions and function declarations for the extract-objs.c module,
   which provides facilities for extracting information from a cpc(1) parse
   tree.

   $Header: extract-objs.h,v 1.1 91/08/25 16:36:52 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef EXTRACT_OBJS_H
#define EXTRACT_OBJS_H

#include <my-types.h>

/* TYPE DEFINITIONS ======================================================== */

/* FUNCTION DECLARATIONS =================================================== */

void ConfigureHashTable( /* void */ );
/* Add entry names and property names to the ID Hash Table that should be
   recognized by this program during the parse. Any entry or property name not
   found in the hash table during the parse is ignored.
*/

Boolean Extract( /* Entry *p_tree, INOUT Pict *pict */ );
/* Extract data from the parse tree 'p_tree', adding the resulting picture
   objects created from that extraction to 'pict'. Return True iff errors were
   encountered during the extraction.
*/

#endif EXTRACT_OBJS_H
