/* RANK.H

   Type definitions and function declarations for the rank.c module, which
   provides facilities for ordering objects in a constraint picture.

   $Header: rank.h,v 1.1 91/08/25 16:48:11 heydon Locked $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef RANK_H
#define RANK_H

/* FUNCTION DECLARATIONS =================================================== */

float AttrValDistance( /* AttrVal min, AttrVal max, IntrvlKind kind */ );
/* Returns the "distance" between the values, analogous to 'max' - 'min'. The
   "types" of the values (and therefore the distance function to apply) are
   determined by 'kind', which must be either IntKind or StringKind.
*/

void OrderObjs( /* Pict *pict */ );
/* This function assigns an "order number" to each box and arrow in 'pict',
   where order numbers start at 0 and increase sequentially such that all
   thick objects have order numbers less than all thin objects. This routine
   also fills in the 'pict->elt' array such that pict->elt[i] is a pointer to
   the Elt with order number 'i'.

   See notebook pages I:123-125 for details on the algorithm.
*/

#endif RANK_H
