
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* SEARCH.H

   $Header: search.h,v 1.5 91/10/02 00:10:20 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   OVERVIEW OF THIS MODULE

   This module provides the function Search_TopLevelPath(), which performs the
   heart of the fs2iff's job. It recursively "searches" a specified "subtree"
   of a filesystem. Another parameter can be used to specify a path down from
   the root of this subtree. In this case, only directories along the path are
   searched, and then the full subtree at the *end* of the path is searched
   completely.

   When a directory is "searched", it's entries are searched recursively, and
   a box is generated for the directory itself. Arrows are then generated to
   reflect the permission differences between the directory and its entries.
   If the global variable 'DummyFiles' is True, a dummy file box is placed
   inside each directory. If the global variable 'DirPerms' is True, arrows
   for 'list' and 'in-del' permissions (on directories) are generated.

   One of the main features of the search is that after the permissions of
   each of the entries in a directory is computed, a vote is taken, and the
   majority permissions are used for the permission of the directory itself.
   In this way, most of the entries "inherit" the permission of their parent
   directory, and so a minimum of extra arrows is generated.
*/

#ifndef SEARCH_H
#define SEARCH_H

/* GLOBAL FUNCTION DECLARATIONS =========================================== */

void Search_TopLevelPath( /* Path path, String search_root */ );
/* Perform a search on the top-level file or directory 'path'. The argument
   'path' is assumed to be the "root" of the filesystem. Arrows are generated
   as if it is the "top-level" file box. That is to say, the permissions on
   any directories containing the final component of 'path' are ignored, and
   the ARROW entries to the 'path' box are generated in the context of all
   "higher" permissions being denied.

   The parameter 'search_root' should be a pathname ending with a '/'
   character; it specifies the root of the *subtree* of the filesystem to
   search. 'path' should be a prefix of 'search_root'. Only one box is
   generated for each directory required to extend 'path' into 'search_root'.
   For example, if 'path' is "/usr1" and 'search_root' is "/usr1/heydon/foo/",
   then a box will be generated for "/usr1/", "heydon/" and "foo/", and the
   search will then proceed to search "/usr1/heydon/foo/" recursively.

   PRE_CONDITION: 'path' is of type Path, and so has been allocated to expand
   in length up to MAXPATHLEN characters total.
*/

#endif SEARCH_H
