/* TOP.H -- Declarations for types used by modules in fs2iff source.

   $Header: top.h,v 1.7 91/11/08 12:27:22 heydon Locked $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef TOP_H
#define TOP_H

#include <sys/param.h>
#include <stdio.h>

#include <my-types.h>

/* For memory allocation macros below */
extern char *malloc();

/* MACRO FUNCTIONS ======================================================== */

/* Command-line syntax
*/
#define SYNTAX "fs2iff [-q] [-u] [-f] [-d] [-o outfile] [pathname]\n"
/*
   If 'pathname' is omitted, the current working directory is assumed.
   First, expand 'pathname' to be an absolute pathname if not one already.
   Then, write out user box information. Finally, write out file boxes for the
   directories leading down to the tail of 'pathname' (making sure that none
   along the way is a symbolic link), and then do a search() on the tail of
   'pathname'.

   If "-q" is specified, all warning messages usually sent to sdterr are
   surpressed. Warning messages are those messages that don't cause execution
   of the program to terminate.

   If "-u" is specified, a dummy user box is placed in each group box and the
   world box. No arrows are attached to these dummy user boxes. The boxes are
   named "GROUP-USER-<groupname>" and "WORLD-USER".

   If "-f" is specified, a dummy file box is placed in each directory box. The
   dummy box is given the type "dir-dummy". No read, write, or execute arrows
   are attached to these dummy file boxes, but list and in-del arrows may be
   (see "-d" below). The boxes are named "DIR-FILE-<dirname>".

   If "-d" is specified, "directory" permissions are created. If -d is
   specified, insert-delete and list permissions are generated for directories
   in addition to the default read, write, and exec permissions generated for
   files. "-d" implies "-f"; the directory arrows are attached to the dummy
   file boxes.

   If "-o" is specified, output is written to "outfile" instead of the
   standard output.

   [ In future implementations, we may choose to allow more than one pathname
   as an argument. In this case, we must make sure that no pathname given is a
   proper substring of any other. We must then generate file boxes for the
   pathname corresponding to the greatest-common-substring of the arguments
   (once they have been expanded to absolute pathnames). ]
*/

/* Dummy object names */
#define DUMMY_WORLD_NAME "WORLD-USER"
#define DUMMY_GROUP_NAME "GROUP-USER-"
#define DUMMY_DIR_NAME   "DIR-FILE-"

/* TYPES ================================================================== */

typedef char Path[MAXPATHLEN+1];
typedef char *PathStr;

/* GLOBAL VARIABLES ======================================================= */

extern String Argv0;		/* tail of name program was invoked with */
extern FILE *fp;		/* output file */
extern Boolean Quiet;		/* surpress warning messages? */
extern Boolean DummyUsers;	/* add dummy group and world users? */
extern Boolean DummyFiles;	/* add dummy directory file objects? */
extern Boolean DirPerms;	/* generate directory permissions? */
extern int MaxNumPerms;		/* maximum number of permissions (in dirs) */

#endif TOP_H
