/* VOTE.C

   Module providing structures and functions for taking votes on permissions
   of entries within a directory.

   $Header: vote.c,v 1.5 91/11/08 12:52:35 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


/* HEADER FILES =========================================================== */

#include "top.h"		/* for MaxNumPerms global variable */
#include "perm.h"
#include "vote.h"

/* LOCAL FUNCTIONS ======================================================== */

/*ARGSUSED*/
void vote_CastVote(curr_entry,perm)
  VoteEntry curr_entry;		/* current VoteTable entry */
  Perm *perm;			/* vote being cast */
/* Cast a single vote for 'perm' given that 'curr_entry' is the current entry
   for the access type the vote is being cast with respect to.
*/
{
    /* STUB */
}

/* GLOBAL FUNCTIONS ======================================================= */

VoteTable Vote_NewTable()
{
    int i,last;
    VoteTable result;

    last = LAST_DIR_ACCESS;
    result = (VoteTable)AllocArray(VoteEntry,last);
    StepIndex(i,0,last) { result[i] = (VoteEntry)NULL; }
    return(result);
}

void Vote_DestroyTable(vote_table)
  VoteTable vote_table;
{
    int i,last;

    last = LAST_DIR_ACCESS;
    StepIndex(i,0,last) {
	if (vote_table[i]) { Dealloc(vote_table[i]); }
    }
    Dealloc(vote_table);
}

void Vote_CastVote(vote_table,perm,kind)
  VoteTable vote_table;
  Perm *perm;
  AccessType kind;
{
    vote_CastVote(vote_table[(int)kind],perm);
}

void Vote_CastVotes(vote_table,set)
  VoteTable vote_table;
  PermSet set;
{
    int i,last;

    last = LAST_DIR_ACCESS;
    StepIndex(i,0,last) {
	vote_CastVote(vote_table[i],set[i]);
    }
}

/*ARGSUSED*/
void Vote_AssignWinners(set,default_perm,vote_table)
  PermSet set;
  Perm *default_perm;
  VoteTable vote_table;
{
    int i,last;

    /* for now, just set all permissions to 'curr_cd' */
    last = LAST_DIR_ACCESS;
    StepIndex(i,0,last) {
	set[i] = Perm_NewCopy(default_perm);
    }
}
