/* VOTE.H

   $Header: vote.h,v 1.4 90/12/04 15:29:33 heydon Locked $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   OVERVIEW OF THIS MODULE

   WHAT THIS MODULE PROVIDES

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef VOTE_H
#define VOTE_H

/* HEADER FILES =========================================================== */

#include <my-defs.h>

/* TYPES ================================================================== */

/* VoteEntry -- each entry is simply a (Perm *) */
typedef Perm *VoteEntry;

/* VoteTable -- an array of VoteEntry's */
typedef VoteEntry *VoteTable;

/* MACRO FUNCTIONS ======================================================== */

/* GLOBAL FUNCTION DECLARATIONS =========================================== */

VoteTable Vote_NewTable( /* void */ );
/* RETURNS a pointer to a newly-created VoteTable. Use Vote_DestroyTable()
   when done with the returned VoteTable.
*/

void Vote_DestroyTable( /* VoteTable vote_table */ );
/* Deallocates the space used by 'vote_table' (created by Vote_NewTable()) and
   all the Perm's associated with it.
*/

void Vote_CastVote( /* VoteTable vote_table, Perm *perm, AccessType kind */ );
/* Cast a vote for the single permission 'perm' of type 'kind' in the
   VoteTable 'vote_table'.
*/

void Vote_CastVotes( /* VoteTable vote_table, PermSet set */ );
/* Cast votes for all permissions (Read, Write, and Exec) in the PermSet 'set'
   in the VoteTable 'vote_table'. Also cast votes for the List and InDel
   permissions if the global DummyFiles is True.
*/

void Vote_AssignWinners( /* OUT PermSet set, Perm *default_perm,
			    VoteTable vote_table */ );
/* Assign to 'set' the "winners" of the vote for all relavent permissions
   (Read, Write, & Exec, and List & InDel if the global Dummy). If no votes
   have been cast for a permission, use 'default_perm' as the "winner" for
   that permission.
*/

#endif VOTE_H
