/*

  iff2lisp.h -- macros and data types for iff2lisp.c

  Created by Karen Kietzke (ky+@cs.cmu.edu) 2/14/91

 */

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <sys/param.h>
#include <stdio.h>
#include <strings.h>
#include "parser.h"
#include "parser.g"
#include "extract.h"
#define NO_MWM_VARS
#include "list_type.h"

/* Append obj to the list whose tail is pointed to by tailptr. */
#define APPEND(obj,tailptr) \
  do{ \
    *(tailptr) = (obj); \
    (tailptr) = &((obj)->next); \
  }while(0)

/* Try to malloc and print an error message if it failed. */
static int MALLOC(size,result,errormsg)
int size;
void **result;
char *errormsg;
{
  if (((*result) = (void*)(malloc(size))) == NULL){
    fprintf (stderr, errormsg);
    return (0);
  }else return (1);
} /* MALLOC() */

static int REALLOC(size,result,errormsg)
int size;
void **result;
char *errormsg;
{
  if (((*result) = (void*)(realloc(*result,size))) == NULL){
    fprintf (stderr, errormsg);
    return (0);
  }else return (1);
} /* REALLOC() */


/* A type to hold extracted inside relations (from an iff file). */
typedef struct extracted_relation{
  struct extracted_relation *next; /* the next value in the list */
  Entry *entry; /* the entry in the parse tree */
} extracted_relation_t;

/* A type to hold "editor" information. */
typedef struct extracted_editor_info{
  /* no "next" -- there should only be one of these */
  Entry *entry;			/* parse table entry */
  char *pictype;
  char *range;
  char *parity;
} extracted_editor_info_t;

/* A type to hold extracted box values (from an iff file). */
typedef struct extracted_box_value{
  struct extracted_box_value *next; /* the next value in the list -- used */
				/* to link boxes together before we */
				/* get them put into an array */
  Entry *entry;			/* parse table entry */
  int sysname;			/* the sysname associated with this box */
  char *name;			/* the name of this box */
  int x;			/* x coordinate of location */
  int y;			/* y coordinate of location */
  int width;
  int height;
  char *box_role;		/* the role of this box */
  char *box_type;		/* the type of this box */
  int thick;			/* thick or thin? */
  int starred;			/* starred? */
  int arrow;			/* any arrows from this box? */

  list_type parent_sysnames;	/* sysnames of parents */
  list_type child_sysnames;	/* sysnames of children */
} extracted_box_value_t;

typedef struct extracted_arrow_value{
  struct extracted_arrow_value *next;
  Entry *entry;			/* parse table entry */
  int sysname;
  int from;			/* box at the tail */
  int to;			/* box at the head */
  list_type label;		/* label on this arrow */
  int negative_parity;		/* is the parity negative? */
  char *kind;			/* what kind of arrow is this? */
  int thick;
  int starred;
  int visible;
} extracted_arrow_value_t;


#define INTER_BOX_SPACING 5
#define CHARACTER_WIDTH 11.7
#define CHARACTER_HEIGHT 20
typedef struct box_location{
  int max_x;
  int max_y;
  int preferred_x;
  int preferred_y;
  int alternate_x;
  int alternate_y;
} box_location_t;
