/* ===========================================================================
  CONVERT.C -- contains conversion functions used by the extraction functions
  to generate useful information from a parsed IFF file.

  $Header: convert.c,v 1.1 90/12/12 22:27:35 heydon Exp $

  Written by Amy Moormann Zaremski for the Miro project at Carnegie Mellon 
===========================================================================*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


/* these declarations should eventually go in a header file 
void myConvertInt();
void ConvertStr();
void ConvertThick();
void ConvertBool();
void myConvertParity();
*/

#include "iff2ps.h"

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void myConvertInt(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
/* Assumes 'p_val_ptr' points to a PropVal with a prop_val_type of IntPValType
   and sets *((int *)val_ptr) to the integer IntValOf(p_val_ptr).
*/
{
#ifdef DEBUG
    if (PropValTypeOf(p_val_ptr) != IntPValType) {
	ProgrammerErrorI("extract.c",
			 "prop_val_type should be IntValType instead of 0x%x",
			 PropValTypeOf(p_val_ptr));
    }
#endif
    *((int *)val_ptr) = IntValOf(p_val_ptr);
}

void ConvertStr(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
/* Assumes 'p_val_ptr' points to a PropVal with a prop_val_type of 
   StringPValType and sets *((char *)val_ptr) to its value.
*/
{
#ifdef E_DEBUG
    if (PropValTypeOf(p_val_ptr) != StringPValType) {
	halt( "prop_val_type should be StringPValType.");
    }
#endif

    *((String *)val_ptr) = StringValOf(p_val_ptr);
  }


/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void ConvertThick(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
/* Assumes 'p_val_ptr' points to a PropVal with a prop_val_type of IdPValType
   and sets *((Bool *)val_ptr) to True if "thick", False if "thin"; else 
   reports an error.
*/
{
#ifdef E_DEBUG
    if (PropValTypeOf(p_val_ptr) != IdPValType) {
	halt( "prop_val_type should be IdValType.");
    }
#endif

    if (SameString("thick",IdValOf(p_val_ptr))) {
	*((Bool *)val_ptr) = TRUE;
    } else if (SameString("thin",IdValOf(p_val_ptr))) {
	*((Bool *)val_ptr) = FALSE;
    } else {
	*((Bool *)val_ptr) = FALSE; 
	ParseErrorS(line_no,
		    "thickness '%s' should be either 'thick' or 'thin'",
		    IdValOf(p_val_ptr));
    }

}

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void myConvertParity(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
/* Assumes 'p_val_ptr' points to a PropVal with a prop_val_type of IdPValType
   and sets *((Bool *)val_ptr) to True if "pos", False if "neg"; else 
   reports an error.
*/
{
#ifdef E_DEBUG
    if (PropValTypeOf(p_val_ptr) != IdPValType) {
	halt( "prop_val_type should be IdValType.");
    }
#endif

    if (SameString("pos",IdValOf(p_val_ptr))) {
	*((Bool *)val_ptr) = TRUE;
    } else if (SameString("neg",IdValOf(p_val_ptr))) {
	*((Bool *)val_ptr) = FALSE;
    } else {
	*((Bool *)val_ptr) = FALSE; 
	ParseErrorS(line_no,
		    "parity '%s' should be either 'pos' or 'neg'",
		    IdValOf(p_val_ptr));
    }

}

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void ConvertBool(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
/* Assumes 'p_val_ptr' points to a PropVal with a prop_val_type of IdPValType
   and sets *((Bool *)val_ptr) to True if "true", False if "false"; else 
   reports an error.
*/
{
#ifdef E_DEBUG
    if (PropValTypeOf(p_val_ptr) != IdPValType) {
	halt( "prop_val_type should be IdValType.");
    }
#endif

    if (SameString("true",IdValOf(p_val_ptr))) {
	*((Bool *)val_ptr) = TRUE;
    } else if (SameString("false",IdValOf(p_val_ptr))) {
	*((Bool *)val_ptr) = FALSE;
    } else {
	*((Bool *)val_ptr) = FALSE; 
	ParseErrorS(line_no,
		    "boolean '%s' should be either 'thick' or 'thin'",
		    IdValOf(p_val_ptr));
    }

}

