/* ===========================================================================
  IFF2PS.C -- main file for the Miro IFF to PostScript translator. 

  $Header: iff2ps.c,v 1.1 90/12/12 22:28:15 heydon Exp $

  Written by Amy Moormann Zaremski for the Miro project at Carnegie Mellon 
===========================================================================*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include "iff2ps.h"

/* ----------------------------------------
  The main function:
    - process command line arguments
    - initialize
    - parse input
    - process input
    - produce postscript calls
    - clean up
----------------------------------------*/
int main(argc, argv)
     int argc;
     char *argv[];
{
  /* local variables */
  FILE *iff_file;
  Entry *parse_tree; 

#ifdef IFF2PS_DEBUG
  printf("IFF2PS:: Entering main\n" );
#endif 

  /* set program name */
  progname = argv[0];

  /** initialize **/
  iff_file = Initialize(argc, argv);

  /** parse **/
  parse_tree=ParseFile(iff_file);

#ifdef IFF2PS_DEBUG
  printf("IFF2PS:: Parsed file %s\n", argv[1]);
/*  myShowParseTree(parse_tree); */
#endif 

  /** process **/
  /* separate out boxes, arrows, and editing info */
  ExtractLists(parse_tree,&boxes,&arrows,&ed_entries);

  /* add highlighting info to boxes & arrows */
  ProcessHighlighting(boxes,arrows,ed_entries);

  /** print **/
  PrintPostscript(boxes, arrows);

  /** clean up **/
  ShutDownParser();

#ifdef IFF2PS_DEBUG
  printf("IFF2PS:: Exiting main\n");
#endif 

  }

/* ------------------------------------------------------------
   Halt : print an error message and halt (unrecoverable error)
------------------------------------------------------------ */
void halt(s)
     char *s;
{
  fprintf(stderr, "%s: %s\n", progname, s);
  exit(1);
}


/* ------------------------------------------------------------
  routines to show entries (snarfed from Allan's parser.c 
  debugging routines) 
------------------------------------------------------------ */

static void ShowPropVal(pval_ptr)
  PropVal *pval_ptr;
{
    ListEntry *list_entry_ptr;

    switch (PropValTypeOf(pval_ptr)) {
      case IntPValType:
	printf("%d",IntValOf(pval_ptr));
	break;
      case IdPValType:
	printf("%s (0x%x)",IdValOf(pval_ptr),(int)IdValOf(pval_ptr));
	break;
      case StringPValType:
	printf("'%s'",StringValOf(pval_ptr),
	       (int)StringValOf(pval_ptr));
	break;
      case ListPValType:
	printf("{ ");
	StepLinkedList(list_entry_ptr,ListHeadOf(pval_ptr)) {
	    ShowPropVal(ListPropValPtrOf(list_entry_ptr));
	    (void)putchar(' ');
	}
	printf("}");
	break;
    }
}

static void ShowAttr(attr_ptr)
  AttrEntry *attr_ptr;
{
    printf("  ** Line Number     = %d\n",AttrLineNumberOf(attr_ptr));
    printf("     Attribute Name  = %s\n",AttrNameOf(attr_ptr));
    printf("     Attribute Value = ");
    ShowPropVal(PropValPtrOf(attr_ptr));
    (void)putchar('\n');
}

static void ShowEntry(entry_ptr)
  Entry *entry_ptr;
{
    AttrEntry *attr_ptr;
    printf("Entry Type: %s (0x%x); Line No. = %d\n",EntryNameOf(entry_ptr),
	   EntryTypeOf(entry_ptr),EntryLineNumberOf(entry_ptr));
    StepLinkedList(attr_ptr,AttrListHeadOf(entry_ptr)) {
	ShowAttr(attr_ptr);
    }
}


void myShowParseTree(p_tree)
  Entry *p_tree;
{
    printf("\nSHOW-PARSE-TREE():\n");
    for (; p_tree != NULL; Next(p_tree))
	ShowEntry(p_tree);
  }


