/* ===========================================================================
  INIT.C -- initialization functions.

  $Header: init.c,v 1.3 91/07/01 15:31:51 heydon Exp $

  Written by Amy Moormann Zaremski for the Miro project at Carnegie Mellon 
===========================================================================*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include "iff2ps.h"

static void ConfigureHashTable()
/* Configure the ID hash table for entries and attribute names to be read by
   this program.
*/
{
    /* Install Entries */
    AddEntryName("ARROW",     ArrowEntry);
    AddEntryName("BOX",       BoxEntry);
    AddEntryName("EDITOR",    EditorEntry);

    /* Install ARROW/BOX Property Names */
    AddPropName("sysname",    ObjectPNames,  IntPValType);
    AddPropName("thickness",  ObjectPNames,  IdPValType);
    AddPropName("starred?",   ObjectPNames,  IdPValType);
    AddPropName("label-loc",  ObjectPNames,  IntListPValType);

    /* Install ARROW Property Names */
    AddPropName("permissions",ArrowPName,    IdListPValType);
    AddPropName("kind",       ArrowPName,    IdPValType);
    AddPropName("tail-loc",   ArrowPName,    IntListPValType);
    AddPropName("head-loc",   ArrowPName,    IntListPValType);
    AddPropName("parity",     ArrowPName,    IdPValType);

    /* Install BOX Property Names */
    AddPropName("name",       BoxPName,      StringPValType);
    AddPropName("loc",        BoxPName,      IntListPValType);
    AddPropName("size",       BoxPName,      IntListPValType);

    /* Install EDITOR Property Names */
    AddPropName("highlightboxes",EditorPName,IntListPValType);
    AddPropName("highlightarrows",EditorPName,IntListPValType);
}

/* ------------------------------------------------------------
   do local initialization -- lists of nodes initially empty 
------------------------------------------------------------*/
FILE *Initialize(argc, argv)
     int argc;
     char *argv[];
{
  FILE *process_parameters();

  /* initialize parser */
  InitParser();
  ConfigureHashTable();

  /* initialize local variables */
  /* processed entry lists */
  boxes = NULL;
  arrows = NULL;
  ed_entries = NULL;

  /* max and min coords */
  max_x = max_y = 0;
  min_x = min_y = CoordLimit;

  /* command line parameters */
  rotate = TRUE;
  center = FALSE;
  scale_factor = 1.0;
  fontsize = 10;
  in_text = FALSE;

  /* use command line args to set global parameters */
  return(process_parameters(argc, argv));
}

FILE *process_parameters(argc, argv)
     int argc;
     char *argv[];
{
    /* process command line arguments using getopt library, and open 
       file (or stdin). Returns pointer to input 'file' */

    /* local declarations */
    int c;
    extern int optind;
    extern char *optarg;
    Bool show_syntax;
    FILE *fp;

    /* process command line options */
    show_syntax = FALSE;
    while ((c = getopt(argc,argv,"ibpcf:s:")) != EOF) {
	switch(c){
	  case 'b':		/* best-fit mode */
	    best_fit = TRUE;
	    break;
	  case 'c':		/* center */
	    center = TRUE;
	    break;
	  case 'f':		/* change fontsize */
	    fontsize = atoi(optarg);
	    break;
	  case 'i':		/* in-text mode */
	    in_text = TRUE;
	    break;
	  case 'p':		/* portrait mode */
	    rotate = FALSE;
	    break;
	  case 's':		/* change scale */
	    scale_factor = atof(optarg);
	    break;
	  case '?':
	  default:
	    show_syntax = TRUE;
	    break;
	}
    }

    /* check for contradictory switches */
    if (center && in_text) {
	halt("-c and -i are mutually exlusive options.\n");
	show_syntax = TRUE;
    } else if (best_fit &&
	       (center || in_text || !rotate || (scale_factor != 1.0))) {
	halt("-b is mutually exclusive with -c, -i, -p, and -s.\n");
	show_syntax = TRUE;
    }
    if (show_syntax) {
	halt("USAGE: iff2ps [-b | [-s <scale>] [-p] [-c|-i]] [-f <size>] [filename]\n");
    }

  /* open file */
  if (optind == (argc-1)) {
    /* last argument is file name */
    if ((fp = fopen(argv[optind],"r")) == NULL)
      halt("File could not be opened for reading.\n");
  } else {
    /* use stdin */
    fp = stdin;
  }
  /* return file pointer */
  return(fp);
}




