/* ===========================================================================
  NODES.C -- contains routines for manipulating nodes of box, arrow and
  ed_node lists. Node functions use CopyString for strings (in my-defs.h).

  $Header: nodes.c,v 1.3 91/07/25 09:28:29 heydon Exp $

  Written by Amy Moormann Zaremski for the Miro project at Carnegie Mellon 
===========================================================================*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include "iff2ps.h"

/* ------------------------------------------------------------
   GENERIC NODE FUNCTIONS
------------------------------------------------------------ */
/* create a new node with default values in slots. */
GenericEntry *InitNode(size) 
     int size;
{
  GenericEntry *new_node;
  char *emalloc();

  new_node = (GenericEntry *) emalloc(size);
  new_node->next = NULL;
  return(new_node);
}
     
/* add node to front of list */
void InsertNode(node,head)
     GenericEntry *node;
     GenericEntry **head;
{
  node->next = *head;
  *head = node;
}

/* memory allocation for nodes */
char *emalloc(n)
unsigned n;
/* allocate space -- malloc plus check for NULL */
{
    char *p, *malloc();
    p = malloc(n);
    if(p == NULL)
	halt("out of memory\n");
    return(p);
}    


/* ------------------------------------------------------------
   BOX NODE FUNCTIONS
------------------------------------------------------------ */

/* set slots of box node */
void SetBoxSlots(node,sysname,name,loc,size,labelloc,thick,starred,highlighted) 
     BoxNode *node;
     int sysname;
     String name;
     Coord loc;
     Coord size;
     Coord labelloc;
     Bool thick;
     Bool starred;
     Bool highlighted; 
{
  node->sysname = sysname;
  CopyString(node->name,name);
  node->loc = loc;
  node->size = size;
  node->labelloc = labelloc;
  node->thick = thick;
  node->starred = starred;
  node->highlighted = highlighted;
}


/* ------------------------------------------------------------
   ARROW NODE FUNCTIONS
------------------------------------------------------------ */

/* set slots of arrow node */
void SetArrowSlots(node,sysname,type,kind,tailloc,headloc,labelloc,parity,thick,starred,highlighted)
     ArrowNode *node;
     int sysname;
     String type;
     String kind;
     Coord tailloc;
     Coord headloc;
     Coord labelloc;
     Bool parity;
     Bool thick;
     Bool starred;
     Bool highlighted; 
{
  node->sysname = sysname;
  node->type = type;		/* ProcessTypeList() allocates a new string */
  CopyString(node->kind,kind);
  node->tailloc = tailloc;
  node->headloc = headloc;
  node->labelloc = labelloc;
  node->parity = parity;
  node->thick = thick;
  node->starred = starred;
  node->highlighted = highlighted; 
}


/* ------------------------------------------------------------
   EDITOR NODE FUNCTIONS
------------------------------------------------------------ */

/* check to see if an object is in the highlighted list */
Bool HighlightedP(key,hll)
     int key;
     IntNode **hll;
/* check through hll list for key; delete if found */
{
    Bool found = FALSE;
    IntNode *p, *q;

    /* first node */
    if ((*hll)->value == key) {
	found = TRUE;
	*hll = (*hll)->next;
    }
    else {
	q = *hll;
	p = q->next;
	while (p != NULL && !found) { 
	    if (p->value == key) {
		found = TRUE;
		q->next = p->next;
	    }		
	    else { /* this isn't it */
		q = p;
		p = p->next;
	    }
	}
    }
    return(found);
}

