/*

  iff2vf.h -- macros and data types for iff2vf.c

  Created by Karen Kietzke (ky+@cs.cmu.edu) 1/21/91

 */

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <sys/param.h>
#include <stdio.h>
#include <strings.h>
#include "parser.h"
#include "parser.g"
#include "extract.h"
#include "util.h"
#include "list_type.h"

/* Append obj to the list whose tail is pointed to by tailptr. */
#define APPEND(obj,tailptr) \
  do{ \
    *(tailptr) = (obj); \
    (tailptr) = &((obj)->next); \
  }while(0)

/* Try to malloc and print an error message if it failed. */
int MALLOC(size,result,errormsg)
int size;
Generic **result;
String errormsg;
{
  if (((*result) = (Generic*)(malloc(size))) == NULL){
    fprintf (stderr, errormsg);
    return (0);
  }else return (1);
} /* MALLOC() */


/* A type to hold extracted inside relations (from an iff file). */
typedef struct extracted_relation{
  struct extracted_relation *next; /* the next value in the list */
  Entry *entry; /* the entry in the parse tree */
} extracted_relation_t;

/* values for extracted_value_t.box_type */
#define USER_TYPE 1
#define FILE_TYPE 2
#define GROUP_TYPE 3

/* A type to hold extracted box values (from an iff file). */
typedef struct extracted_value{
  struct extracted_value *next; /* the next value in the list -- used */
				/* to link entries together before we */
				/* get them put into an array */
  int sysname; /* the sysname associated with this entry */
  int parent_sysname;
  String name; /* the name of this entry */
  String fullname; /* the full path */
  int box_type; /* the type of this box -- USER_TYPE or FILE_TYPE */
} extracted_value_t;

/* maximum size for one-word buffer */
#define FP2LIST_BUFSIZE 2000

/* values for extracted_sem_arrow_t.access */
#define POSITIVE_ACCESS 1
#define NEGATIVE_ACCESS 2
/* assume none means negative */
#define NONE_ACCESS 2

/* A type to hold extracted semantic arrows (from ambig results). */
typedef struct extracted_sem_arrow{
  struct extracted_sem_arrow *next;
  int user_sysname;
  int file_sysname;
  String access_type;
  int access;
} extracted_sem_arrow_t;
