/* prober.h

$Header: prober.h,v 1.1 90/11/27 23:26:15 mwm Locked $

$Log:	prober.h,v $
 * Revision 1.1  90/11/27  23:26:15  mwm
 * Initial revision
 * 
 * Revision 1.1  90/09/11  13:34:57  mwm
 * Initial revision
 * 

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include "Tables.h"

typedef unsigned short PermT;	/* same as that in stat.h */
typedef struct {
    int user;		/* uid_t   would be nice, but only complicates
			   life because the passwd reading routines return
			   ids as   int,  *not*   uid_t   (which is
			   short   in the current state of mach).  This is
			   a problem because these values are often passed
			   by reference, and short* != int* */
    int group;		/* gid_t   likewise */
    int *posu, *negu;
    int *posg, *negg;
    int *realtail;	/* needed for memory management */
    int whos_valid;
    PermT perms;
} DirPermT;

extern int max_perm_stack_depth;

#define VALID_WORLD 3
#define VALID_GROUP 2
#define VALID_OWNER 1

#define any_owner(tail) ((tail) -> whos_valid >= VALID_OWNER)
#define any_group(tail) ((tail) -> whos_valid >= VALID_GROUP)
#define any_world(tail) ((tail) -> whos_valid >= VALID_WORLD)

#define no_world(tail) (any_world(tail) ? (tail) -> whos_valid = VALID_GROUP:0)
#define no_group(tail) (any_group(tail) ? (tail) -> whos_valid = VALID_OWNER:0)
#define no_owner(tail) (any_owner(tail) ? (tail) -> whos_valid = 0 : 0)
