
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/*  util.h

$Header: util.h,v 1.3 91/04/15 18:19:53 ky Exp $

	Routines supplied by util.c and util.h

FIND CURRENT DIRECTORY
	-- loads the current directory's full pathname into global variable
	   cwd; there will be *no* trailing slash ('/') in the pathname.
	-- initialize the variable by calling   init_cwd(),   with no
	   parameters.

SQUISH PATHNAME
	-- Places all pathnames into canonical form (eliminates double
	   slashes, nested parent pointers or current directory pointers).
	   Does *not* take symlinks or other filesystem quirks into
	   account, merely does a syntax-based operation.
	-- Requires global variable   cwd   be initialized, returns a
	   pointer to a static storage location (which must be copied if
	   the value is to be retained).
	-- char *squish (pathname)

CURRENT DATE
	-- char *whats_today()   returns a readable static string with the
	   current date and time.

HOSTNAME
	-- char *what_host ()   returns the name of the machine on which
	   the program is being run

GUARANTEED MEMORY
	-- char *must_malloc (bytes, desc)   will either successfully
	   allocate   bytes   bytes of memory, or issue an error containing
	   desc   and exit(1).

STRING POINTER COMPARE
	-- int strptrcmp (s1, s2)   compares the strings pointed to by s1
	   and s2 and returns the compare.  Useful for hash table entries.
	-- int strptrptrcmp (s1, s2)   does likewise, with an additional
	   level of indirection

STACK MEMORY ADT
	-- Sometimes it's useful to keep extra information around in a
	   depth-first search.  For instance, when scanning a filesystem
	   you might want to remember the names of all files or
	   directories in an ancestor's directory.  This Abstract Data
	   Type provides an easy way to remember lots of extra information
	   in a stack.  It's also quite simple to free up space; just free
	   up the single element nearest the new top of stack (where you
	   want to be after popping old, useless data), and all of the
	   memory in between will automatically free up.
	-- StackMemoryT *st_init (block_len)   -- initializes an object of
	   StackMemoryT.  You simply specify the longest block length that
	   you ever expect to allocate (but you're not bound to it, the
	   routines can increase this limit if usage demands it).  Returns
	   NULL on failure.
	-- char *st_alloc (memptr, bytes)   -- what you call instead of
	   malloc.  memptr is the address of a valid StackMemoryT pointer;
	   the value of that pointer will change if another block of
	   memory gets allocated.  Returns a pointer to a word-aligned
	   free section of memory if successful, NULL on failure.
	-- int st_free (memptr, loc)   -- free up all stack frames above
	   the given memory   loc.   No memory is actually deallocated, we
	   just adjust some pointers (this helps prevent thrashing on
	   malloc calls).  Returns 1 if successful, 0 otherwise.
	-- int st_in (memptr, loc)   -- see if   loc   lies somewhere on
	   the stack.  Returns 0 on error or if   loc   is not in the stack,
	   1 otherwise.

PERMANENT STRING STORAGE
	-- char *new_string (str) -- allocate a copy of   str   in
	   permanent storage (i.e. storage which need never be reclaimed).
	   Doesn't return if no memory is available.

$Log:	util.h,v $
 * Revision 1.3  91/04/15  18:19:53  ky
 * include mwm.h
 * 
 * Revision 1.2  91/04/15  18:13:42  ky
 * SMT is in mwm.h now.
 * 
 * Revision 1.1  90/11/27  23:29:41  mwm
 * Initial revision
 * 
 * Revision 1.1  90/09/11  13:36:01  mwm
 * Initial revision
 * 

*/

#include <mwm.h>

#define HOSTNAMELEN 100
#define STRING_BLOCK_SIZE 8192	/* Some string ID's are allocated once and
				   never freed up.  This defines the size
				   of the blocks to use for this
				   allocation in new_string(). */

int strptrcmp (/* char **s1, **s2 */);
int strptrptrcmp (/* char ***s1, ***s2 */);

extern char cwd[];
