/* util_test.c -- 

$Header: util_test.c,v 1.1 90/11/27 23:30:42 mwm Exp $

	Program by:  Mark Maimone   13/Jun/90   CMU Computer Science
	Last modified:  13/Jun/90

$Log:	util_test.c,v $
 * Revision 1.1  90/11/27  23:30:42  mwm
 * Initial revision
 * 
 * Revision 1.1  90/09/11  13:36:06  mwm
 * Initial revision
 * 

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <mwm.h>
#include "util.h"

#define my_entry(swit,count,type,store,size) p_entry \
	("-", (swit), P_CASE_INSENSITIVE, (count), (type), (store), (size))
#define MAX_OTHERS 100
#define SQUISH_TEST_DEF 1
#define SQUISH_DEF_DEF 0

int show_help = 0;
int test_squish = SQUISH_TEST_DEF;
int squish_defaults = SQUISH_DEF_DEF;

/* INCLUDE PARSE STATE VARIABLES HERE */

char *this_program;

arg_info table[] = {
    my_entry ("h", P_NO_ARGS, P_INT, &show_help, 1),
    my_entry ("?", P_NO_ARGS, P_INT, &show_help, 1),
    my_entry ("s", P_NO_ARGS, P_INT, &test_squish, 1),
    my_entry ("!s", P_NO_ARGS, P_INT, &test_squish, 0),
    my_entry ("sd", P_NO_ARGS, P_INT, &squish_defaults, 1),
    my_entry ("!sd", P_NO_ARGS, P_INT, &squish_defaults, 0)

/* INCLUDE ADDITIONAL COMMAND LINE ARGUMENTS HERE */

}; /* table */
#define table_size (sizeof (table) / sizeof (arg_info))

extern char cwd[];

main (argc, argv)
int argc;
char *argv[];
{
    char *others[MAX_OTHERS + 1];

    if (argv[0])
	this_program = argv[0];
    else
	this_program = "";

    if (!parse_args (argc, argv, table, table_size, others, MAX_OTHERS)) {
	fprintf (stderr, "%s:  Illegal arguments, quitting\n", this_program);
	exit (1);
    } /* if (!parse_args) */

    if (show_help) {
	do_show_help ();
	exit (0);
    } /* if (show_help) */

    init_cwd ();
    check_squish (others, MAX_OTHERS);
} /* main */

char *squish_strings[] = {
    "miro", "miro",
    "miro/test", "miro/test",
    "/usr/mwm/miro/test", "/usr/mwm/miro/test",
    "/usr/mwm/miro/test/", "/usr/mwm/miro/test/",
    "//usr/mwm", "/usr/mwm",
    "//usr//mwm//", "/usr/mwm/",
    "/usr/../etc/passwd", "/etc/passwd",
    "/", "/",
    "//", "/",
    "/usr/../etc/passwd/../../usr1/mwm/miro/doc/../../doc/miro//",
	"/usr1/mwm/doc/miro/",
    "./miro", "miro",
    "./miro/", "miro/",
    "/./miro", "/miro",
    "miro/.", "miro",
    "miro/./", "miro/",
    "/usr/mwm//.//miro/foo", "/usr/mwm/miro/foo",
    "/usr/mwm//.//miro/foo/", "/usr/mwm/miro/foo/",
    ".", cwd,
    "", cwd,
    "/../a/usr/mwm/foo//", "/../a/usr/mwm/foo/",
    "file../foo", "file../foo",
    "file./foo", "file./foo",
    ".../../.", cwd,
    "...", "...",
    ".../.../", ".../.../",
    "a..x/y..cf", "a..x/y..cf",
/*  "./", cwd followed by "/", */
    0, 0
}; /* squish_strings */

check_squish (pathnames, maxcount)
char *pathnames[];
int maxcount;
{
    int i;

    if ((maxcount < 1 || *pathnames == NULL) && !squish_defaults) {
	fprintf (stderr, "%s:  no pathnames to squish!\n", this_program);
	return;
    } /* if maxcount < 1 */

    printf ("===>  Checking  squish()\n");

    if (squish_defaults) {
	int bad;
	char *result;

	for (i = 0; squish_strings[i]; i += 2) {
	    result = squish (squish_strings[i]);
	    if (bad = strcmp (squish_strings[i + 1], result))
		printf ("*** ERROR ***  ");
	    printf ("'%s' becomes '%s'\n", squish_strings[i], result);
	    if (bad)
		printf ("\t(should have been '%s')\n", squish_strings[i + 1]);
	} /* for i = 0 */
    } /* if squish_defaults */

    for (i = 0; i < maxcount && pathnames[i]; i++) {
	printf ("'%s' becomes ", pathnames[i]);
	printf ("'%s'\n", squish (pathnames[i]));
    } /* for i = 0 */

} /* check_squish */

do_show_help ()
{
    char storage[1000];
    char *build_usage ();

    fprintf (stderr, "%s:  util.c verifier\n\n", this_program);
    fprintf (stderr, "SWITCHES:\n");
    fprintf (stderr, "\t-h,?\tShow this HELP message\n");
    fprintf (stderr, "\t-s\tTest the SQUISH routine%s\n", SQUISH_TEST_DEF ?
	    " [default]" : "");
    fprintf (stderr, "\t-!s\tDo NOT test the SQUISH routine%s\n",
	    SQUISH_TEST_DEF ? "" : " [default]");
    fprintf (stderr, "\t-sd\tUse builtin SQUISH tests%s\n", SQUISH_DEF_DEF ?
	    " [default]" : "");
    fprintf (stderr, "\t-!sd\tDo NOT use builtin SQUISH tests%s\n",
	    SQUISH_DEF_DEF ? "" : " [default]");
    fprintf (stderr, "\n%s\n", build_usage (table, table_size, storage,
	    1000));
} /* show_help */
