/* verifier.c -- 

	Program by:  Mark Maimone   24/03/90   CMU Computer Science
	Last modified:  24/03/90

TODO
    Make the LoadACL code a little more flexible

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <mwm.h>
#include <string.h>			/* for strcpy() */
#include "vf.h"
#include "Tables.h"

#define my_entry(swit,count,type,store,size) p_entry \
	("-", (swit), P_CASE_INSENSITIVE, (count), (type), (store), (size))
#define MAX_OTHERS 1
#define MAX_GROUP_DEPTH 10	/* max number of grouping tables */
#define DEFAULT_PROBER_USER_FILE "users.out"
#define DEFAULT_AMBIG_USER_FILE "ambig.users"
#define DEFAULT_GROUP_FILE "groups.out"
#define DEFAULT_PROBER_OUTPUT_FILE "prober.out"
#define DEFAULT_AMBIG_OUTPUT_FILE "ambig.perms"
#define DEFAULT_PERM_FILE "permissions"
#define DEFAULT_TEMPDIR "/tmp"
#define DEFAULT_LOGFILE ""
#define DEFAULT_LINE_BUF_MAX 2000
#define DEFAULT_GROUP_ERROR_MAX 20
#define DEFAULT_QUIET 0
#define DEFAULT_VERBOSE 0
#define DEFAULT_ID_SEP ':'

char idsep = DEFAULT_ID_SEP;

int show_help = 0;
int quiet = DEFAULT_QUIET;
int verbose = DEFAULT_VERBOSE;		/* Output *every* discrepancy */
int line_buf_max = DEFAULT_LINE_BUF_MAX;
int group_error_max = DEFAULT_GROUP_ERROR_MAX;	/* max errors to display
						   per file */
char *prober_user_file = DEFAULT_PROBER_USER_FILE;
char *ambig_user_file = DEFAULT_AMBIG_USER_FILE;
char *perm_file = DEFAULT_PERM_FILE;
char *group_files[MAX_GROUP_DEPTH + 1] = { 0 };	/* parse_args will zero
						   out this entry anyway */
char *prober_output_file = DEFAULT_PROBER_OUTPUT_FILE;
char *ambig_output_file = DEFAULT_AMBIG_OUTPUT_FILE;
char *logfile = DEFAULT_LOGFILE;

/* INCLUDE PARSE STATE VARIABLES HERE */

char *this_program;

arg_info table[] = {
    my_entry ("h", P_NO_ARGS, P_INT, &show_help, 1),
    my_entry ("?", P_NO_ARGS, P_INT, &show_help, 1),
    my_entry ("pu", P_ONE_ARG, P_OLD_FILE, &prober_user_file, 0),
    my_entry ("au", P_ONE_ARG, P_OLD_FILE, &ambig_user_file, 0),
    my_entry ("pp", P_ONE_ARG, P_OLD_FILE, &prober_output_file, 0),
    my_entry ("ap", P_ONE_ARG, P_OLD_FILE, &ambig_output_file, 0),
    my_entry ("g", P_INFINITE_ARGS, P_OLD_FILE, group_files, MAX_GROUP_DEPTH),
    my_entry ("p", P_ONE_ARG, P_OLD_FILE, &perm_file, 0),
    my_entry ("ge", P_ONE_ARG, P_INT, &group_error_max, 0),
    my_entry ("lb", P_ONE_ARG, P_INT, &line_buf_max, 0),
    my_entry ("s", P_ONE_ARG, P_CHAR, &idsep, 0),
    my_entry ("l", P_ONE_ARG, P_FILE, &logfile, 0),
    my_entry ("q", P_NO_ARGS, P_INT, &quiet, !DEFAULT_QUIET),
    my_entry ("v", P_NO_ARGS, P_INT, &verbose, !DEFAULT_VERBOSE),

/* INCLUDE ADDITIONAL COMMAND LINE ARGUMENTS HERE */

}; /* table */
#define table_size (sizeof (table) / sizeof (arg_info))


FILE *vf_log = stderr;
int group_errors = 0, vector_len = 0;
char **uid_vector = NULL;
PermVectorT *pv = NULL, *av = NULL;
HashTableT *uid2index;
HashTableT **group_tables;

main (argc, argv)
int argc;
char *argv[];
{
    FILE *prober, *ambig;
    char *others[MAX_OTHERS + 1];

    if (argv[0])
	this_program = argv[0];
    else
	this_program = "";

    if (!parse_args (argc, argv, table, table_size, others, MAX_OTHERS)) {
	fprintf (stderr, "%s:  Illegal arguments, quitting\n", this_program);
	exit (1);
    } /* if (!parse_args) */

    if (show_help) {
	do_show_help ();
	exit (0);
    } /* if (show_help) */

/* Can't have both verbose and quiet! */

    if (verbose && quiet)
	verbose = quiet = 0;

    einit ();		/* Needed because of old code in list_type.c */

    SetFilePointer (&vf_log, logfile, "log", "w", 1);
    fprintf (vf_log, "# Miro' Verifier Log    %s\n", whats_today ());
    SetFilePointer (&prober, prober_output_file, "prober output", "r", 1);
    SetFilePointer (&ambig, ambig_output_file, "ambig output", "r", 1);
    LoadUserLists (prober_user_file, ambig_user_file);
    if (*group_files == NULL) {
	group_files[0] = DEFAULT_GROUP_FILE;
	group_files[1] = NULL;
    } /* if *group_files == NULL */

    LoadGroupFiles (group_files);
    LoadPermissions (perm_file);

    CompareFiles (prober, ambig);

    if (vf_log && vf_log != stderr && vf_log != stdout)
	fclose (vf_log);
    if (prober && prober != stdin)
	fclose (prober);
    if (ambig && ambig != stdin)
	fclose (ambig);
} /* main */





#define MISSING_FILE(name) Warn ( \
	"File %s missing in Miro' picture\n", (name))
#define MISSING_BOX(name) Warn ( \
	"Box %s missing in filesystem\n", (name))


/* CompareFiles -- Here's where it all happens.  The input streams are
   read in lockstep, since they are assumed to be lexicographically sorted
   by filename.  Whenever a discrepancy arises (filesystem file not
   represented in the picture, one user's permission doesn't match) write
   the offending line(s) to the log file.  Eventually want to write just
   the differences out,not the whole line(s). */

CompareFiles (prober, ambig)
FILE *prober, *ambig;
{
    int pempty = 0, aempty = 0;
    char *pfile, *afile;

/* Add 3 to MAXPATHLEN for :, newline, and null terminator */

    pfile = must_malloc (MAXPATHLEN + 3, "Prober filename buffer");
    afile = must_malloc (MAXPATHLEN + 3, "Ambiguity filename buffer");
    afile[MAXPATHLEN] = pfile[MAXPATHLEN] = '\0';
    ClearPermVector (pv);
    ClearPermVector (av);
    pempty = !LoadOneFile (prober, pfile, pv, "Prober output");
    aempty = !LoadOneFile (ambig, afile, av, "Ambig output");

    if (pempty)
	Warn ("Empty file list from prober!!\n");
    if (aempty)
	Warn ("Empty file list from ambiguity checker!!\n");

    while (!pempty && !aempty) {
	int cmp = strcmp (pfile, afile);

	cmp = (cmp < 0) ? -1 : ((cmp > 0) ? 1 : 0);
	switch (cmp) {
	    case -1:
	        MISSING_FILE (pfile);
		pempty = !LoadOneFile (prober, pfile, pv, "Prober output");
	        break;
	    case 0:
		CompareVectors (pfile, pv, av);
	        pempty = !LoadOneFile (prober, pfile, pv, "Prober output");
		aempty = !LoadOneFile (ambig, afile, av, "Ambig output");
	        break;
	    case 1:
	        MISSING_BOX (afile);
		aempty = !LoadOneFile (ambig, afile, av, "Ambig output");
	        break;
	} /* switch */
    } /* while !pempty */

    if (!pempty)
	do {
	    MISSING_FILE (pfile);
	} while (LoadOneFile (prober, pfile, pv, "Prober output"));

    if (!aempty)
        do {
	    MISSING_BOX (afile);
	} while (LoadOneFile (ambig, afile, av, "Prober output"));

} /* CompareFiles */



ClearPermVector (vec)
PermVectorT *vec;
{
    int i;

    for (i = vector_len; i; i--)
	*vec++ = (PermVectorT) 0;
} /* ClearPermVector */


/* CompareVectors -- verify that the two permission vectors are identical.
   If not, write a message to the log file */

CompareVectors (file, pv, av)
char *file;
PermVectorT *pv, *av;
{
    int i;

    for (i = vector_len - 1; i >= 0; i--) {
	if (pv[i] != av[i])
	    if (!verbose) {
		MustWarn ("%s:  Permissions for %s differ\n", file,
			uid_vector[i]);
		break;
	    } else {
		MustWarn ("%s:  ", file);
		write_perms (vf_log, pv[i] ^ av[i]);
		MustWarn (" permissions differ for %s\n",
			uid_vector[i]);
	    } /* else */
    } /* for i = vector_len */
} /* CompareVectors */



do_show_help ()
{
    char storage[1000];
    char *build_usage ();

    fprintf (stderr, "%s:  Miro Instance Picture Verifier\n\n", this_program);
    fprintf (stderr, "SWITCHES:\n");
    fprintf (stderr, "\t-h,?\tShow this HELP message\n");
    fprintf (stderr, "\t-pu\tSet PROBER USERS file [default \"%s\"]\n",
	    DEFAULT_PROBER_USER_FILE);
    fprintf (stderr, "\t-au\tSet AMBIG USERS file [default \"%s\"]\n",
	    DEFAULT_AMBIG_USER_FILE);
    fprintf (stderr, "\t-pp\tSet PROBER OUTPUT file [default \"%s\"]\n",
	    DEFAULT_PROBER_OUTPUT_FILE);
    fprintf (stderr, "\t-ap\tSet AMBIG OUTPUT file [default \"%s\"]\n",
	    DEFAULT_AMBIG_OUTPUT_FILE);
    fprintf (stderr, "\t-g\tSet next GROUP file (up to %d) [default \"%s\"]\n",
	    MAX_GROUP_DEPTH, DEFAULT_GROUP_FILE);
    fprintf (stderr, "\t-l\tSet LOG file [default \"%s\"]\n",
	    ((DEFAULT_LOGFILE && *DEFAULT_LOGFILE) ? DEFAULT_LOGFILE :
	    "stderr"));
    fprintf (stderr, "\t-lb\tSet LINE BUFFER length [default %d]\n",
	    DEFAULT_LINE_BUF_MAX);
    fprintf (stderr, "\t-p\tSet PERMISSIONS file [default \"%s\"]\n",
	    DEFAULT_PERM_FILE);
    fprintf (stderr,
	    "\t-ge\tSet max printable GROUP file ERRORS [default %d]\n"
	    , DEFAULT_GROUP_ERROR_MAX);
    fprintf (stderr, "\t-s\tSet id SEPARATOR character [default '%c']\n",
	    DEFAULT_ID_SEP);
    fprintf (stderr, "\t-q\tTurn QUIET mode %s [default %s]\n", DEFAULT_QUIET
	     ? "off" : "on", DEFAULT_QUIET ? "on" : "off");
    fprintf (stderr, "\t-v\tTurn VERBOSE mode %s [default %s]\n",
	    DEFAULT_VERBOSE ? "off" : "on", DEFAULT_VERBOSE ? "on" : "off");
    fprintf (stderr, "\n%s\n", build_usage (table, table_size, storage,
	    1000));
} /* show_help */
