/* rmnl.c -- Remove Single Newlines from input

    $Header: rmnl.c,v 1.2 90/12/10 05:57:09 mwm Exp $

	Program by:  Mark Maimone   28/11/90   CMU Computer Science
	Last modified:  28/11/90

    $Log:	rmnl.c,v $
 * Revision 1.2  90/12/10  05:57:09  mwm
 * changed c == EOF to feof (fp), commented state variables
 * 

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <mwm.h>

#define my_entry(swit,count,type,store,size) p_entry \
	("-", (swit), P_CASE_INSENSITIVE, (count), (type), (store), (size))
#define MAX_OTHERS 1
#define DEFAULT_FILLER " "

int show_help = 0;
int max_line_len = 0;
char *filler = DEFAULT_FILLER;
/* INCLUDE PARSE STATE VARIABLES HERE */

char *this_program;

arg_info table[] = {
    my_entry ("l", P_ONE_ARG, P_INT, &max_line_len, 0),
    my_entry ("f", P_ONE_ARG, P_STRING, &filler, 0),
    my_entry ("h", P_NO_ARGS, P_INT, &show_help, 1),
    my_entry ("?", P_NO_ARGS, P_INT, &show_help, 1),

/* INCLUDE ADDITIONAL COMMAND LINE ARGUMENTS HERE */

}; /* table */
#define table_size (sizeof (table) / sizeof (arg_info))


main (argc, argv)
int argc;
char *argv[];
{
    char *others[MAX_OTHERS + 1];

    if (argv[0])
	this_program = argv[0];
    else
	this_program = "";

    if (!parse_args (argc, argv, table, table_size, others, MAX_OTHERS)) {
	fprintf (stderr, "%s:  Illegal arguments, quitting\n", this_program);
	exit (1);
    } /* if (!parse_args) */

    if (show_help) {
	do_show_help ();
	exit (0);
    } /* if (show_help) */

    if (others[0] == NULL)
	rmnl (stdin, stdout);
    else {
	int i;
	FILE *fp, *fopen ();

	for (i = 0; i < MAX_OTHERS && others[i]; i++) {
	    if ((fp = fopen (others[i], "r")) == NULL)
		fprintf (stderr, "%s:  Couldn't open '%s', skipping.\n",
			this_program, others[i]);
	    else {
		rmnl (fp, stdout);
		fclose (fp);
	    } /* else */
	} /* for */
    } /* else */
} /* main */


rmnl (fp, outfp)
FILE *fp, *outfp;
{
    char c;
    int count = 0;		/* Number of chars on current output line */
    int filler_len = strlen (filler);
    int line = 1;		/* Current line number in output file */
    int lastline = 0;		/* Number of most recent output line for
				   which an error was output */
    int multiple_newline;	/* BOOLEAN -- true iff several adjacent
				   newlines appear in the input file */

    c = getc(fp);
    while (!feof (fp)) {
	if (c != '\n') {
	    count++;
	    putc (c, outfp);
	    c = getc(fp);
	} else {
	    multiple_newline = 0;
	    while (!feof (fp) && (c=getc(fp)) == '\n') {
		multiple_newline = 1;
	    }
	    if (multiple_newline || feof (fp)) {
		putc ('\n', outfp);
		count = 0;
		line++;
	    } else {
		fprintf (outfp, "%s", filler);
		count += filler_len;
	    } /* else */
	} /* else */

	if (max_line_len && count > max_line_len && line != lastline) {
	    fprintf (stderr, "%s: Line %d in output file exceeds %d chars!\n",
		    this_program, line, max_line_len);
	    lastline = line;
	}
    } /* while (!feof (fp)) */
} /* rmnl */


do_show_help ()
{
    char storage[1000];
    char *build_usage ();

    fprintf (stderr, "%s:  Remove single Newlines\n\n", this_program);
    fprintf (stderr, "   This program filters the named input file(s) by ");
    fprintf (stderr, "replacing all single\nnewlines with a filler string ");
    fprintf (stderr, "(default blank) and all sequences of\ntwo or more ");
    fprintf (stderr, "newlines by a single newline. It will warn if the ");
    fprintf (stderr, "length\nof an output line exceeds a user-defined ");
    fprintf (stderr, "maximum (default none). If no\ninput files are named, ");
    fprintf (stderr, "stdin is used.\n\n");
    fprintf (stderr, "SWITCHES:\n");
    fprintf (stderr, "\t-l\tSet max LINE size [default none]\n");
    fprintf (stderr, "\t-f\tSet the FILLER string [default \"%s\"]\n",
	    DEFAULT_FILLER);
    fprintf (stderr, "\t-h,?\tShow this HELP message\n");
    fprintf (stderr, "\n%s\n", build_usage (table, table_size, storage,
	    1000));
} /* show_help */
